/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.showcase.movies;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeDateType;
import com.ocs.dynamo.domain.model.AttributeSelectMode;
import com.ocs.dynamo.domain.model.VisibilityType;
import com.ocs.dynamo.domain.model.annotation.Attribute;
import com.ocs.dynamo.domain.model.annotation.AttributeOrder;
import com.ocs.dynamo.domain.model.annotation.Model;
import com.ocs.dynamo.showcase.movies.Country;
import com.ocs.dynamo.showcase.movies.MovieRating;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="MOVIE")
@Model(displayProperty="title")
@AttributeOrder(attributeNames={"id", "title", "releaseDate"})
public class Movie
extends AbstractEntity<Integer> {
    private static final long serialVersionUID = -6342590031746525068L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @NotNull
    @Attribute(searchable=true, main=true)
    private String title;
    @Attribute(url=true)
    @Column(name="IMDB_URL")
    private String imdbUrl;
    @Attribute(searchable=true, dateType=AttributeDateType.DATE)
    @Column(name="RELEASE_DATE")
    private Date releaseDate;
    @Attribute(searchable=true, sortable=false, displayName="MPAA Rating")
    @Enumerated(value=EnumType.STRING)
    @Column(name="MPAA_RATING")
    private MovieRating rating;
    @NotNull
    private BigDecimal gross;
    @Attribute(showInTable=VisibilityType.SHOW, complexEditable=true)
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="TAG")
    @Column(name="Name")
    private Set<String> tags;
    @Attribute(searchable=true, trueRepresentation="Yep!", falseRepresentation="Nope!")
    private Boolean documentary;
    @Attribute(complexEditable=true, searchable=true, searchSelectMode=AttributeSelectMode.TOKEN, multipleSearch=true, displayName="Country", showInTable=VisibilityType.SHOW)
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="COUNTRY_ID")
    private Country country;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public MovieRating getRating() {
        return this.rating;
    }

    public void setRating(MovieRating rating) {
        this.rating = rating;
    }

    public BigDecimal getGross() {
        return this.gross;
    }

    public void setGross(BigDecimal gross) {
        this.gross = gross;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Boolean getDocumentary() {
        return this.documentary;
    }

    public void setDocumentary(Boolean documentary) {
        this.documentary = documentary;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getImdbUrl() {
        return this.imdbUrl;
    }

    public void setImdbUrl(String imdbUrl) {
        this.imdbUrl = imdbUrl;
    }
}

