/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.test;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractTransactionalJUnit4SpringContextTests;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@ContextConfiguration(locations={"classpath:META-INF/testApplicationContext.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
public abstract class BaseIntegrationTest
extends AbstractTransactionalJUnit4SpringContextTests {
    private static final Logger LOG = Logger.getLogger(BaseIntegrationTest.class);
    @Autowired
    private PlatformTransactionManager transactionManager;
    @PersistenceContext
    protected EntityManager entityManager;

    protected Logger getLog() {
        return LOG;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void wait(int miliSeconds) {
        try {
            Thread.sleep(miliSeconds);
        }
        catch (InterruptedException ex) {
            Assert.fail((String)"Waiting period was interrupted");
        }
    }

    protected TransactionStatus startTransaction() {
        return this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
    }

    protected void commitTransaction(TransactionStatus status) {
        this.transactionManager.commit(status);
    }
}

