/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.test;

import com.ocs.dynamo.dao.BaseDao;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import junitx.util.PrivateAccessor;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.test.util.ReflectionTestUtils;

public final class MockUtil {
    private static final String UI_FIELD_NAME = "ui";

    private MockUtil() {
    }

    public static <ID, X extends AbstractEntity<ID>> X captureSave(BaseDao<ID, X> dao, Class<X> clazz) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(clazz);
        ((BaseDao)Mockito.verify(dao)).save((AbstractEntity)captor.capture());
        return (X)((AbstractEntity)captor.getValue());
    }

    public static <ID, X extends AbstractEntity<ID>> List<X> captureSaveList(BaseDao<ID, X> dao) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((BaseDao)Mockito.verify(dao)).save((List)captor.capture());
        return (List)captor.getValue();
    }

    public static <ID, X extends AbstractEntity<ID>> List<X> captureSaves(BaseDao<ID, X> dao, Class<X> clazz, int times) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(clazz);
        ((BaseDao)Mockito.verify(dao, (VerificationMode)Mockito.times((int)times))).save((AbstractEntity)captor.capture());
        return captor.getAllValues();
    }

    public static <ID, X extends AbstractEntity<ID>> X captureServiceSave(BaseService<ID, X> service, Class<X> clazz) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(clazz);
        ((BaseService)Mockito.verify(service)).save((AbstractEntity)captor.capture());
        return (X)((AbstractEntity)captor.getValue());
    }

    public static <ID, X extends AbstractEntity<ID>> List<X> captureServiceSaveList(BaseService<ID, X> service) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((BaseService)Mockito.verify(service)).save((List)captor.capture());
        return (List)captor.getValue();
    }

    public static <ID, X extends AbstractEntity<ID>> List<X> captureServiceSaves(BaseService<ID, X> service, Class<X> clazz, int times) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(clazz);
        ((BaseService)Mockito.verify(service, (VerificationMode)Mockito.times((int)times))).save((AbstractEntity)captor.capture());
        return captor.getAllValues();
    }

    public static void injectMessageService(Object target, String basename) {
        ResourceBundleMessageSource rmb = new ResourceBundleMessageSource();
        rmb.setBasename(basename);
        MessageService ms = (MessageService)Mockito.spy(MessageService.class);
        ReflectionTestUtils.setField((Object)ms, (String)"source", (Object)rmb);
        ReflectionTestUtils.setField((Object)target, (String)"messageService", (Object)ms);
    }

    public static void injectUI(Object object, Object ui) {
        try {
            PrivateAccessor.setField((Object)object, (String)UI_FIELD_NAME, (Object)ui);
        }
        catch (NoSuchFieldException e) {
            throw new OCSRuntimeException("No field named 'UI' could be found");
        }
    }

    public static <ID, X extends AbstractEntity<ID>> void mockFetchById(BaseDao<ID, X> dao, ID id, X entity) {
        Mockito.when((Object)dao.fetchById(Matchers.eq(id), (FetchJoinInformation[])Matchers.anyVararg())).thenReturn(entity);
    }

    public static void mockMessageService(MessageService messageService) {
        Mockito.when((Object)messageService.getMessage(Matchers.anyString(), (Locale)Matchers.any(Locale.class))).thenAnswer(invocation -> (String)invocation.getArguments()[0]);
        Mockito.when((Object)messageService.getMessage(Matchers.anyString(), (Locale)Matchers.any(Locale.class), (Object[])Matchers.anyVararg())).thenAnswer(invocation -> (String)invocation.getArguments()[0]);
        Mockito.when((Object)messageService.getMessage(Matchers.anyString(), (Locale)Matchers.any(Locale.class))).thenAnswer(invocation -> (String)invocation.getArguments()[0]);
        Mockito.when((Object)messageService.getEnumMessage((Class)Matchers.any(), (Enum)Matchers.any(Enum.class), (Locale)Matchers.any(Locale.class))).thenAnswer(invocation -> invocation.getArguments()[1].toString());
    }

    public static <ID, X extends AbstractEntity<ID>> void mockSave(BaseDao<ID, X> dao, Class<X> clazz) {
        Mockito.when((Object)dao.save((AbstractEntity)Matchers.any(clazz))).thenAnswer(invocation -> invocation.getArguments()[0]);
        Mockito.when((Object)dao.save((List)Matchers.any(List.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
    }

    public static <ID, X extends AbstractEntity<ID>> void mockSaveList(BaseDao<ID, X> dao) {
        Mockito.when((Object)dao.save((List)Matchers.any(List.class))).thenAnswer(invocation -> (List)invocation.getArguments()[0]);
    }

    public static <ID, U extends AbstractEntity<ID>> void mockServiceSave(BaseService<ID, U> service, Class<U> clazz) {
        Mockito.when((Object)service.save((AbstractEntity)Matchers.any(clazz))).thenAnswer(invocation -> invocation.getArguments()[0]);
    }

    public static void registerMocks(ConfigurableListableBeanFactory factory, Object subject) {
        MockUtil.registerMocks(factory, subject, subject.getClass());
    }

    public static void registerMocks(ConfigurableListableBeanFactory factory, Object subject, Class<?> clazz) {
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.getAnnotation(Mock.class) == null) continue;
                factory.registerSingleton(field.getName(), field.get(subject));
            }
            if (clazz.getSuperclass() != null) {
                MockUtil.registerMocks(factory, subject, clazz.getSuperclass());
            }
        }
        catch (Exception e) {
            throw new OCSRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

