/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.test;

import com.ocs.dynamo.test.MockUtil;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Properties;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseMockitoTest {
    private GenericApplicationContext applicationContext;

    protected void addBeanToContext(Object bean) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
        this.applicationContext.getBeanFactory().registerSingleton(bean.getClass().getName(), bean);
    }

    public void addBeanToContext(String qualifier, Object bean) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean(bean);
        this.applicationContext.getBeanFactory().registerSingleton(qualifier, bean);
    }

    protected String formatNumber(String str) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance();
        char ds = df.getDecimalFormatSymbols().getDecimalSeparator();
        return str.replace(',', ds);
    }

    protected Map<String, Object> getSystemProperties() {
        return (Map)this.applicationContext.getBean("systemProperties");
    }

    protected void initialize(Object subject) {
        this.applicationContext.getAutowireCapableBeanFactory().initializeBean(subject, subject.getClass().getSimpleName());
    }

    public void registerProperties(String name, Map<String, Object> properties) {
        this.applicationContext.getBeanFactory().registerSingleton(name, properties);
    }

    public void registerProperties(String name, Properties properties) {
        this.applicationContext.getBeanFactory().registerSingleton(name, (Object)properties);
    }

    @Before
    public void setUp() throws Exception {
        this.setupApplicationContext();
    }

    protected void setupApplicationContext() {
        this.applicationContext = new AnnotationConfigApplicationContext();
        this.applicationContext.refresh();
        this.applicationContext.start();
        MockUtil.registerMocks(this.applicationContext.getBeanFactory(), this);
    }

    protected <T> T wireTestSubject(T subject) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean(subject);
        this.initialize(subject);
        return subject;
    }
}

