/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.field;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.easybatch.core.field.FieldExtractor;
import org.easybatch.core.util.Utils;

public class BeanFieldExtractor<P>
implements FieldExtractor<P> {
    private final String[] fields;
    private final Map<String, Method> getters;

    public BeanFieldExtractor(Class<P> type, String ... fields) throws IntrospectionException {
        this.getters = Utils.getGetters(type);
        this.fields = fields.length == 0 ? this.getters.keySet().toArray(new String[this.getters.size()]) : fields;
    }

    @Override
    public Iterable<Object> extractFields(P payload) throws Exception {
        Object[] values = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            values[i] = this.getValue(this.fields[i], payload);
        }
        return Arrays.asList(values);
    }

    protected Object getValue(String field, P object) throws InvocationTargetException, IllegalAccessException {
        return this.getters.get(field).invoke(object, new Object[0]);
    }
}

