/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.easybatch.core.jmx.JobMonitoringListener;

public class JobMonitorProxy
implements Runnable {
    private static final String JMX_SERVICE_URL = "service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi";
    private static final Logger LOGGER = Logger.getLogger(JobMonitorProxy.class.getName());
    private String host;
    private int port;
    private String jobName;
    private List<JobMonitoringListener> notificationListeners;

    public JobMonitorProxy(String host, int port, String jobName) {
        this.host = host;
        this.port = port;
        this.jobName = jobName;
        this.notificationListeners = new ArrayList<JobMonitoringListener>();
    }

    public void addMonitoringListener(JobMonitoringListener jobMonitoringListener) {
        this.notificationListeners.add(jobMonitoringListener);
    }

    @Override
    public void run() {
        try {
            String serviceURL = String.format(JMX_SERVICE_URL, this.host, this.port);
            JMXServiceURL url = new JMXServiceURL(serviceURL);
            ObjectName objectName = new ObjectName("org.easybatch.core.monitor:name=" + this.jobName);
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, new HashMap());
            MBeanServerConnection mBeanServerConnection = jmxConnector.getMBeanServerConnection();
            this.registerNotificationListeners(objectName, mBeanServerConnection, jmxConnector);
            LOGGER.info("Listening to notifications from " + serviceURL);
        }
        catch (IOException | InstanceNotFoundException | MalformedObjectNameException e) {
            LOGGER.log(Level.SEVERE, "Unable to listen to job monitoring notifications", e);
        }
    }

    private void registerNotificationListeners(ObjectName objectName, MBeanServerConnection mBeanServerConnection, JMXConnector jmxConnector) throws InstanceNotFoundException, IOException {
        for (JobMonitoringListener notificationListener : this.notificationListeners) {
            mBeanServerConnection.addNotificationListener(objectName, notificationListener, null, null);
            jmxConnector.addConnectionNotificationListener(notificationListener, new ConnectionClosedNotificationFilter(), null);
            jmxConnector.addConnectionNotificationListener(notificationListener, new ConnectionOpenedNotificationFilter(), null);
        }
    }

    private class ConnectionOpenedNotificationFilter
    implements NotificationFilter {
        private ConnectionOpenedNotificationFilter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return notification.getType().equals("jmx.remote.connection.opened");
        }
    }

    private class ConnectionClosedNotificationFilter
    implements NotificationFilter {
        private ConnectionClosedNotificationFilter() {
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            return notification.getType().equals("jmx.remote.connection.closed");
        }
    }
}

