/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.job;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.easybatch.core.job.BatchWritingException;
import org.easybatch.core.job.ErrorThresholdExceededException;
import org.easybatch.core.job.Job;
import org.easybatch.core.job.JobMetrics;
import org.easybatch.core.job.JobMonitor;
import org.easybatch.core.job.JobParameters;
import org.easybatch.core.job.JobReport;
import org.easybatch.core.job.JobStatus;
import org.easybatch.core.job.NoOpRecordReader;
import org.easybatch.core.job.NoOpRecordWriter;
import org.easybatch.core.job.RecordReaderOpeningException;
import org.easybatch.core.job.RecordReadingException;
import org.easybatch.core.job.RecordTracker;
import org.easybatch.core.job.RecordWriterOpeningException;
import org.easybatch.core.listener.BatchListener;
import org.easybatch.core.listener.CompositeBatchListener;
import org.easybatch.core.listener.CompositeJobListener;
import org.easybatch.core.listener.CompositePipelineListener;
import org.easybatch.core.listener.CompositeRecordReaderListener;
import org.easybatch.core.listener.CompositeRecordWriterListener;
import org.easybatch.core.listener.JobListener;
import org.easybatch.core.listener.PipelineListener;
import org.easybatch.core.listener.RecordReaderListener;
import org.easybatch.core.listener.RecordWriterListener;
import org.easybatch.core.processor.CompositeRecordProcessor;
import org.easybatch.core.processor.RecordProcessor;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.util.Utils;
import org.easybatch.core.writer.RecordWriter;

class BatchJob
implements Job {
    private static final Logger LOGGER = Logger.getLogger(BatchJob.class.getName());
    private static final String DEFAULT_JOB_NAME = "job";
    private String name;
    private RecordReader recordReader;
    private RecordWriter recordWriter;
    private RecordProcessor recordProcessor;
    private RecordTracker recordTracker;
    private JobListener jobListener;
    private BatchListener batchListener;
    private RecordReaderListener recordReaderListener;
    private RecordWriterListener recordWriterListener;
    private PipelineListener pipelineListener;
    private JobParameters parameters;
    private JobMetrics metrics;
    private JobReport report;
    private JobMonitor monitor;

    BatchJob(JobParameters parameters) {
        this.parameters = parameters;
        this.name = DEFAULT_JOB_NAME;
        this.metrics = new JobMetrics();
        this.report = new JobReport();
        this.report.setParameters(parameters);
        this.report.setMetrics(this.metrics);
        this.report.setJobName(this.name);
        this.monitor = new JobMonitor(this.report);
        this.recordReader = new NoOpRecordReader();
        this.recordProcessor = new CompositeRecordProcessor();
        this.recordWriter = new NoOpRecordWriter();
        this.recordReaderListener = new CompositeRecordReaderListener();
        this.pipelineListener = new CompositePipelineListener();
        this.recordWriterListener = new CompositeRecordWriterListener();
        this.batchListener = new CompositeBatchListener();
        this.jobListener = new CompositeJobListener();
        this.recordTracker = new RecordTracker();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JobReport call() {
        this.start();
        try {
            this.openReader();
            this.openWriter();
            this.setStatus(JobStatus.STARTED);
            while (this.moreRecords()) {
                Batch batch = this.readAndProcessBatch();
                this.writeBatch(batch);
            }
            this.setStatus(JobStatus.STOPPING);
        }
        catch (Exception exception) {
            this.fail(exception);
            JobReport jobReport = this.report;
            return jobReport;
        }
        finally {
            this.closeReader();
            this.closeWriter();
        }
        this.complete();
        return this.report;
    }

    private void start() {
        this.setStatus(JobStatus.STARTING);
        this.jobListener.beforeJobStart(this.parameters);
        this.recordTracker = new RecordTracker();
        this.metrics.setStartTime(System.currentTimeMillis());
        LOGGER.log(Level.INFO, "Batch size: {0}", this.parameters.getBatchSize());
        LOGGER.log(Level.INFO, "Error threshold: {0}", Utils.formatErrorThreshold(this.parameters.getErrorThreshold()));
        LOGGER.log(Level.INFO, "Jmx monitoring: {0}", this.parameters.isJmxMonitoring());
        this.registerJobMonitor();
    }

    private void registerJobMonitor() {
        if (this.parameters.isJmxMonitoring()) {
            this.monitor.registerJmxMBeanFor(this);
        }
    }

    private void openReader() throws RecordReaderOpeningException {
        try {
            LOGGER.log(Level.FINE, "Opening record reader");
            this.recordReader.open();
        }
        catch (Exception e) {
            throw new RecordReaderOpeningException("Unable to open record reader", e);
        }
    }

    private void openWriter() throws RecordWriterOpeningException {
        try {
            LOGGER.log(Level.FINE, "Opening record writer");
            this.recordWriter.open();
        }
        catch (Exception e) {
            throw new RecordWriterOpeningException("Unable to open record writer", e);
        }
    }

    private void setStatus(JobStatus status) {
        LOGGER.log(Level.INFO, "Job ''{0}'' " + status.name().toLowerCase(), this.name);
        this.report.setStatus(status);
    }

    private boolean moreRecords() {
        return this.recordTracker.moreRecords();
    }

    private Batch readAndProcessBatch() throws RecordReadingException, ErrorThresholdExceededException {
        Batch batch = new Batch();
        this.batchListener.beforeBatchReading();
        for (int i = 0; i < this.parameters.getBatchSize(); ++i) {
            Record record = this.readRecord();
            if (record == null) {
                this.recordTracker.noMoreRecords();
                break;
            }
            this.metrics.incrementReadCount();
            this.processRecord(record, batch);
        }
        this.batchListener.afterBatchProcessing(batch);
        return batch;
    }

    private Record readRecord() throws RecordReadingException {
        try {
            LOGGER.log(Level.FINE, "Reading next record");
            this.recordReaderListener.beforeRecordReading();
            Record record = this.recordReader.readRecord();
            this.recordReaderListener.afterRecordReading(record);
            return record;
        }
        catch (Exception e) {
            this.recordReaderListener.onRecordReadingException(e);
            throw new RecordReadingException("Unable to read next record", e);
        }
    }

    private void processRecord(Record record, Batch batch) throws ErrorThresholdExceededException {
        block4: {
            try {
                LOGGER.log(Level.FINE, "Processing {0}", record);
                this.notifyJobUpdate();
                this.pipelineListener.beforeRecordProcessing(record);
                Object processedRecord = this.recordProcessor.processRecord(record);
                this.pipelineListener.afterRecordProcessing(record, (Record)processedRecord);
                if (processedRecord == null) {
                    LOGGER.log(Level.FINE, "{0} has been filtered", record);
                    this.metrics.incrementFilteredCount();
                } else {
                    batch.addRecord((Record)processedRecord);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to process " + record, e);
                this.pipelineListener.onRecordProcessingException(record, e);
                this.metrics.incrementErrorCount();
                this.report.setLastError(e);
                if (this.metrics.getErrorCount() <= this.parameters.getErrorThreshold()) break block4;
                throw new ErrorThresholdExceededException("Error threshold exceeded. Aborting execution", e);
            }
        }
    }

    private void writeBatch(Batch batch) throws BatchWritingException {
        LOGGER.log(Level.FINE, "Writing {0}", batch);
        try {
            if (!batch.isEmpty()) {
                this.recordWriterListener.beforeRecordWriting(batch);
                this.recordWriter.writeRecords(batch);
                this.recordWriterListener.afterRecordWriting(batch);
                this.batchListener.afterBatchWriting(batch);
                this.metrics.incrementWriteCount(batch.size());
            }
        }
        catch (Exception e) {
            this.recordWriterListener.onRecordWritingException(batch, e);
            this.batchListener.onBatchWritingException(batch, e);
            throw new BatchWritingException("Unable to write records", e);
        }
    }

    private void teardown(JobStatus status) {
        this.report.setStatus(status);
        this.metrics.setEndTime(System.currentTimeMillis());
        LOGGER.log(Level.INFO, "Job ''{0}'' finished with status: {1}", new Object[]{this.name, this.report.getStatus()});
        this.notifyJobUpdate();
        this.jobListener.afterJobEnd(this.report);
    }

    private void complete() {
        this.teardown(JobStatus.COMPLETED);
    }

    private void fail(Exception exception) {
        String reason = exception.getMessage();
        Throwable error = exception.getCause();
        LOGGER.log(Level.SEVERE, reason, error);
        this.report.setLastError(error);
        this.teardown(JobStatus.FAILED);
    }

    private void closeReader() {
        try {
            LOGGER.log(Level.FINE, "Closing record reader");
            this.recordReader.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to close record reader", e);
            this.report.setLastError(e);
        }
    }

    private void closeWriter() {
        try {
            LOGGER.log(Level.FINE, "Closing record writer");
            this.recordWriter.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to close record writer", e);
            this.report.setLastError(e);
        }
    }

    private void notifyJobUpdate() {
        if (this.parameters.isJmxMonitoring()) {
            this.monitor.notifyJobReportUpdate();
        }
    }

    public void setRecordReader(RecordReader recordReader) {
        this.recordReader = recordReader;
    }

    public void setRecordWriter(RecordWriter recordWriter) {
        this.recordWriter = recordWriter;
    }

    public void addRecordProcessor(RecordProcessor recordProcessor) {
        ((CompositeRecordProcessor)this.recordProcessor).addRecordProcessor(recordProcessor);
    }

    public void addBatchListener(BatchListener batchListener) {
        ((CompositeBatchListener)this.batchListener).addBatchListener(batchListener);
    }

    public void addJobListener(JobListener jobListener) {
        ((CompositeJobListener)this.jobListener).addJobListener(jobListener);
    }

    public void addRecordReaderListener(RecordReaderListener recordReaderListener) {
        ((CompositeRecordReaderListener)this.recordReaderListener).addRecordReaderListener(recordReaderListener);
    }

    public void addRecordWriterListener(RecordWriterListener recordWriterListener) {
        ((CompositeRecordWriterListener)this.recordWriterListener).addRecordWriterListener(recordWriterListener);
    }

    public void addPipelineListener(PipelineListener pipelineListener) {
        ((CompositePipelineListener)this.pipelineListener).addPipelineListener(pipelineListener);
    }

    public void setName(String name) {
        this.name = name;
        this.report.setJobName(name);
    }
}

