/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.job;

import java.util.Map;
import org.easybatch.core.job.JobMetrics;
import org.easybatch.core.job.JobParameters;
import org.easybatch.core.job.JobReport;
import org.easybatch.core.job.JobReportFormatter;
import org.easybatch.core.util.Utils;

public class DefaultJobReportFormatter
implements JobReportFormatter<String> {
    @Override
    public String formatReport(JobReport jobReport) {
        StringBuilder sb = new StringBuilder("Job Report:");
        sb.append(Utils.LINE_SEPARATOR).append("===========");
        sb.append(Utils.LINE_SEPARATOR).append("Name: ").append(jobReport.getJobName());
        sb.append(Utils.LINE_SEPARATOR).append("Status: ").append((Object)jobReport.getStatus());
        JobParameters parameters = jobReport.getParameters();
        sb.append(Utils.LINE_SEPARATOR).append("Parameters:");
        sb.append(Utils.LINE_SEPARATOR).append("\tBatch size = ").append(parameters.getBatchSize());
        sb.append(Utils.LINE_SEPARATOR).append("\tError threshold = ").append(Utils.formatErrorThreshold(parameters.getErrorThreshold()));
        sb.append(Utils.LINE_SEPARATOR).append("\tJmx monitoring = ").append(parameters.isJmxMonitoring());
        JobMetrics metrics = jobReport.getMetrics();
        sb.append(Utils.LINE_SEPARATOR).append("Metrics:");
        sb.append(Utils.LINE_SEPARATOR).append("\tStart time = ").append(Utils.formatTime(metrics.getStartTime()));
        sb.append(Utils.LINE_SEPARATOR).append("\tEnd time = ").append(Utils.formatTime(metrics.getEndTime()));
        sb.append(Utils.LINE_SEPARATOR).append("\tDuration = ").append(Utils.formatDuration(metrics.getDuration()));
        sb.append(Utils.LINE_SEPARATOR).append("\tRead count = ").append(metrics.getReadCount());
        sb.append(Utils.LINE_SEPARATOR).append("\tWrite count = ").append(metrics.getWriteCount());
        sb.append(Utils.LINE_SEPARATOR).append("\tFiltered count = ").append(metrics.getFilteredCount());
        sb.append(Utils.LINE_SEPARATOR).append("\tError count = ").append(metrics.getErrorCount());
        Map<String, Object> customMetrics = metrics.getCustomMetrics();
        for (Map.Entry<String, Object> customMetric : customMetrics.entrySet()) {
            sb.append(Utils.LINE_SEPARATOR).append("\t").append(customMetric.getKey()).append(" = ").append(customMetric.getValue());
        }
        return sb.toString();
    }
}

