/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.easybatch.core.job.JobMetrics;
import org.easybatch.core.job.JobParameters;
import org.easybatch.core.job.JobReport;
import org.easybatch.core.job.JobReportMerger;
import org.easybatch.core.job.JobStatus;

public class DefaultJobReportMerger
implements JobReportMerger {
    @Override
    public JobReport mergerReports(JobReport ... jobReports) {
        ArrayList<Long> startTimes = new ArrayList<Long>();
        ArrayList<Long> endTimes = new ArrayList<Long>();
        ArrayList<String> jobNames = new ArrayList<String>();
        JobParameters parameters = new JobParameters();
        JobMetrics metrics = new JobMetrics();
        JobReport finalJobReport = new JobReport();
        finalJobReport.setParameters(parameters);
        finalJobReport.setMetrics(metrics);
        finalJobReport.setStatus(JobStatus.COMPLETED);
        for (JobReport jobReport : jobReports) {
            startTimes.add(jobReport.getMetrics().getStartTime());
            endTimes.add(jobReport.getMetrics().getEndTime());
            this.calculateReadRecords(finalJobReport, jobReport);
            this.calculateWrittenRecords(finalJobReport, jobReport);
            this.calculateFilteredRecords(finalJobReport, jobReport);
            this.calculateErrorRecords(finalJobReport, jobReport);
            this.setStatus(finalJobReport, jobReport);
            jobNames.add(jobReport.getJobName());
        }
        finalJobReport.getMetrics().setStartTime((Long)Collections.min(startTimes));
        finalJobReport.getMetrics().setEndTime((Long)Collections.max(endTimes));
        finalJobReport.setJobName(this.concatenate(jobNames));
        return finalJobReport;
    }

    private void setStatus(JobReport finalJobReport, JobReport jobReport) {
        if (JobStatus.FAILED.equals((Object)jobReport.getStatus())) {
            finalJobReport.setStatus(JobStatus.FAILED);
        }
    }

    private void calculateReadRecords(JobReport finalJobReport, JobReport jobReport) {
        int i = 0;
        while ((long)i < jobReport.getMetrics().getReadCount()) {
            finalJobReport.getMetrics().incrementReadCount();
            ++i;
        }
    }

    private void calculateWrittenRecords(JobReport finalJobReport, JobReport jobReport) {
        finalJobReport.getMetrics().incrementWriteCount(jobReport.getMetrics().getWriteCount());
    }

    private void calculateErrorRecords(JobReport finalJobReport, JobReport jobReport) {
        int i = 0;
        while ((long)i < jobReport.getMetrics().getErrorCount()) {
            finalJobReport.getMetrics().incrementErrorCount();
            ++i;
        }
    }

    private void calculateFilteredRecords(JobReport finalJobReport, JobReport jobReport) {
        int i = 0;
        while ((long)i < jobReport.getMetrics().getFilteredCount()) {
            finalJobReport.getMetrics().incrementFilteredCount();
            ++i;
        }
    }

    private String concatenate(List<String> names) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }
}

