/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.job;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.easybatch.core.filter.RecordFilter;
import org.easybatch.core.job.BatchJob;
import org.easybatch.core.job.Job;
import org.easybatch.core.job.JobParameters;
import org.easybatch.core.listener.BatchListener;
import org.easybatch.core.listener.JobListener;
import org.easybatch.core.listener.PipelineListener;
import org.easybatch.core.listener.RecordReaderListener;
import org.easybatch.core.listener.RecordWriterListener;
import org.easybatch.core.mapper.RecordMapper;
import org.easybatch.core.marshaller.RecordMarshaller;
import org.easybatch.core.processor.RecordProcessor;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.util.Utils;
import org.easybatch.core.validator.RecordValidator;
import org.easybatch.core.writer.RecordWriter;

public final class JobBuilder {
    private static final Logger LOGGER = Logger.getLogger(BatchJob.class.getName());
    private BatchJob job;
    private JobParameters parameters = new JobParameters();

    public JobBuilder() {
        this.job = new BatchJob(this.parameters);
    }

    public static JobBuilder aNewJob() {
        return new JobBuilder();
    }

    public JobBuilder named(String name) {
        Utils.checkNotNull(name, "job name");
        this.job.setName(name);
        return this;
    }

    public JobBuilder reader(RecordReader recordReader) {
        Utils.checkNotNull(recordReader, "record reader");
        this.job.setRecordReader(recordReader);
        return this;
    }

    public JobBuilder filter(RecordFilter recordFilter) {
        Utils.checkNotNull(recordFilter, "record filter");
        this.job.addRecordProcessor(recordFilter);
        return this;
    }

    public JobBuilder mapper(RecordMapper recordMapper) {
        Utils.checkNotNull(recordMapper, "record mapper");
        this.job.addRecordProcessor(recordMapper);
        return this;
    }

    public JobBuilder validator(RecordValidator recordValidator) {
        Utils.checkNotNull(recordValidator, "record validator");
        this.job.addRecordProcessor(recordValidator);
        return this;
    }

    public JobBuilder processor(RecordProcessor recordProcessor) {
        Utils.checkNotNull(recordProcessor, "record processor");
        this.job.addRecordProcessor(recordProcessor);
        return this;
    }

    public JobBuilder marshaller(RecordMarshaller recordMarshaller) {
        Utils.checkNotNull(recordMarshaller, "record marshaller");
        this.job.addRecordProcessor(recordMarshaller);
        return this;
    }

    public JobBuilder writer(RecordWriter recordWriter) {
        Utils.checkNotNull(recordWriter, "record writer");
        this.job.setRecordWriter(recordWriter);
        return this;
    }

    public JobBuilder errorThreshold(long errorThreshold) {
        if (errorThreshold < 1L) {
            throw new IllegalArgumentException("error threshold must be >= 1");
        }
        this.parameters.setErrorThreshold(errorThreshold);
        return this;
    }

    public JobBuilder enableJmx(boolean jmx) {
        this.parameters.setJmxMonitoring(jmx);
        return this;
    }

    public JobBuilder batchSize(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("Batch size must be >= 1");
        }
        this.parameters.setBatchSize(batchSize);
        return this;
    }

    public JobBuilder jobListener(JobListener jobListener) {
        Utils.checkNotNull(jobListener, "job listener");
        this.job.addJobListener(jobListener);
        return this;
    }

    public JobBuilder batchListener(BatchListener batchListener) {
        Utils.checkNotNull(batchListener, "batch listener");
        this.job.addBatchListener(batchListener);
        return this;
    }

    public JobBuilder readerListener(RecordReaderListener recordReaderListener) {
        Utils.checkNotNull(recordReaderListener, "record reader listener");
        this.job.addRecordReaderListener(recordReaderListener);
        return this;
    }

    public JobBuilder pipelineListener(PipelineListener pipelineListener) {
        Utils.checkNotNull(pipelineListener, "pipeline listener");
        this.job.addPipelineListener(pipelineListener);
        return this;
    }

    public JobBuilder writerListener(RecordWriterListener recordWriterListener) {
        Utils.checkNotNull(recordWriterListener, "record writer listener");
        this.job.addRecordWriterListener(recordWriterListener);
        return this;
    }

    public Job build() {
        return this.job;
    }

    static {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(BatchJob.class.getResourceAsStream("/logging.properties"));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load logging configuration file", e);
        }
    }
}

