/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.easybatch.core.job.Job;
import org.easybatch.core.job.JobReport;
import org.easybatch.core.util.Utils;

public class JobExecutor {
    private ExecutorService executorService;

    public JobExecutor() {
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public JobExecutor(int nbWorkers) {
        this.executorService = Executors.newFixedThreadPool(nbWorkers);
    }

    public JobExecutor(ExecutorService executorService) {
        Utils.checkNotNull(executorService, "executor service");
        this.executorService = executorService;
    }

    public JobReport execute(Job job) {
        try {
            return this.executorService.submit(job).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to execute job " + job.getName(), e);
        }
    }

    public Future<JobReport> submit(Job job) {
        return this.executorService.submit(job);
    }

    public List<Future<JobReport>> submitAll(Job ... jobs) {
        ArrayList jobList = new ArrayList();
        Collections.addAll(jobList, jobs);
        try {
            return this.executorService.invokeAll(jobList);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to execute jobs", e);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

