/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.job;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JobMetrics
implements Serializable {
    private long startTime;
    private long endTime;
    private long readCount;
    private long writeCount;
    private long filteredCount;
    private long errorCount;
    private Map<String, Object> customMetrics = new HashMap<String, Object>();

    public void incrementFilteredCount() {
        ++this.filteredCount;
    }

    public void incrementErrorCount() {
        ++this.errorCount;
    }

    public void incrementReadCount() {
        ++this.readCount;
    }

    public void incrementWriteCount(long count) {
        this.writeCount += count;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    public long getFilteredCount() {
        return this.filteredCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public void addMetric(String name, Object value) {
        this.customMetrics.put(name, value);
    }

    public Map<String, Object> getCustomMetrics() {
        return this.customMetrics;
    }
}

