/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.job;

import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.easybatch.core.job.Job;
import org.easybatch.core.job.JobMonitorMBean;
import org.easybatch.core.job.JobReport;
import org.easybatch.core.util.Utils;

class JobMonitor
extends NotificationBroadcasterSupport
implements JobMonitorMBean {
    private static final Logger LOGGER = Logger.getLogger(JobMonitor.class.getName());
    private long sequenceNumber = 1L;
    private JobReport jobReport;

    public JobMonitor(JobReport jobReport) {
        this.jobReport = jobReport;
    }

    @Override
    public String getJobName() {
        return this.jobReport.getJobName();
    }

    @Override
    public long getReadCount() {
        return this.jobReport.getMetrics().getReadCount();
    }

    @Override
    public long getFilteredCount() {
        return this.jobReport.getMetrics().getFilteredCount();
    }

    @Override
    public long getErrorCount() {
        return this.jobReport.getMetrics().getErrorCount();
    }

    @Override
    public long getWriteCount() {
        return this.jobReport.getMetrics().getWriteCount();
    }

    @Override
    public String getStartTime() {
        return Utils.formatTime(this.jobReport.getMetrics().getStartTime());
    }

    @Override
    public String getEndTime() {
        return this.jobReport.getMetrics().getEndTime() == 0L ? "" : Utils.formatTime(this.jobReport.getMetrics().getEndTime());
    }

    @Override
    public String getJobStatus() {
        return this.jobReport.getStatus().name();
    }

    void notifyJobReportUpdate() {
        AttributeChangeNotification notification = new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "job report updated", "JobReport", JobReport.class.getName(), null, this.jobReport);
        this.sendNotification(notification);
    }

    void registerJmxMBeanFor(Job job) {
        LOGGER.log(Level.INFO, "Registering JMX MBean for job {0}", job.getName());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.easybatch.core.monitor:name=" + job.getName());
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(this, name);
                LOGGER.log(Level.INFO, "JMX MBean registered successfully as: {0}", name.getCanonicalName());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Unable to register MBean for job %s", job.getName()), e);
        }
    }
}

