/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.listener;

import java.util.ArrayList;
import java.util.List;
import org.easybatch.core.listener.BatchListener;
import org.easybatch.core.record.Batch;

public class CompositeBatchListener
implements BatchListener {
    private List<BatchListener> listeners;

    public CompositeBatchListener() {
        this(new ArrayList<BatchListener>());
    }

    public CompositeBatchListener(List<BatchListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeBatchReading() {
        for (BatchListener listener : this.listeners) {
            listener.beforeBatchReading();
        }
    }

    @Override
    public void afterBatchProcessing(Batch batch) {
        for (BatchListener listener : this.listeners) {
            listener.afterBatchProcessing(batch);
        }
    }

    @Override
    public void afterBatchWriting(Batch batch) {
        for (BatchListener listener : this.listeners) {
            listener.afterBatchWriting(batch);
        }
    }

    @Override
    public void onBatchWritingException(Batch batch, Throwable throwable) {
        for (BatchListener listener : this.listeners) {
            listener.onBatchWritingException(batch, throwable);
        }
    }

    public void addBatchListener(BatchListener batchListener) {
        this.listeners.add(batchListener);
    }
}

