/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.listener;

import java.util.ArrayList;
import java.util.List;
import org.easybatch.core.job.JobParameters;
import org.easybatch.core.job.JobReport;
import org.easybatch.core.listener.JobListener;

public class CompositeJobListener
implements JobListener {
    private List<JobListener> listeners;

    public CompositeJobListener() {
        this(new ArrayList<JobListener>());
    }

    public CompositeJobListener(List<JobListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeJobStart(JobParameters jobParameters) {
        for (JobListener listener : this.listeners) {
            listener.beforeJobStart(jobParameters);
        }
    }

    @Override
    public void afterJobEnd(JobReport jobReport) {
        for (JobListener listener : this.listeners) {
            listener.afterJobEnd(jobReport);
        }
    }

    public void addJobListener(JobListener jobListener) {
        this.listeners.add(jobListener);
    }
}

