/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.listener;

import java.util.ArrayList;
import java.util.List;
import org.easybatch.core.listener.PipelineListener;
import org.easybatch.core.record.Record;

public class CompositePipelineListener
implements PipelineListener {
    private List<PipelineListener> listeners;

    public CompositePipelineListener() {
        this(new ArrayList<PipelineListener>());
    }

    public CompositePipelineListener(List<PipelineListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public Record beforeRecordProcessing(Record record) {
        Record recordToProcess = record;
        for (PipelineListener listener : this.listeners) {
            recordToProcess = listener.beforeRecordProcessing(recordToProcess);
        }
        return recordToProcess;
    }

    @Override
    public void afterRecordProcessing(Record inputRecord, Record outputRecord) {
        for (PipelineListener listener : this.listeners) {
            listener.afterRecordProcessing(inputRecord, outputRecord);
        }
    }

    @Override
    public void onRecordProcessingException(Record record, Throwable throwable) {
        for (PipelineListener listener : this.listeners) {
            listener.onRecordProcessingException(record, throwable);
        }
    }

    public void addPipelineListener(PipelineListener pipelineListener) {
        this.listeners.add(pipelineListener);
    }
}

