/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.listener;

import java.util.ArrayList;
import java.util.List;
import org.easybatch.core.listener.RecordReaderListener;
import org.easybatch.core.record.Record;

public class CompositeRecordReaderListener
implements RecordReaderListener {
    private List<RecordReaderListener> listeners;

    public CompositeRecordReaderListener() {
        this(new ArrayList<RecordReaderListener>());
    }

    public CompositeRecordReaderListener(List<RecordReaderListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeRecordReading() {
        for (RecordReaderListener listener : this.listeners) {
            listener.beforeRecordReading();
        }
    }

    @Override
    public void afterRecordReading(Record record) {
        for (RecordReaderListener listener : this.listeners) {
            listener.afterRecordReading(record);
        }
    }

    @Override
    public void onRecordReadingException(Throwable throwable) {
        for (RecordReaderListener listener : this.listeners) {
            listener.onRecordReadingException(throwable);
        }
    }

    public void addRecordReaderListener(RecordReaderListener recordReaderListener) {
        this.listeners.add(recordReaderListener);
    }
}

