/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.listener;

import java.util.ArrayList;
import java.util.List;
import org.easybatch.core.listener.RecordWriterListener;
import org.easybatch.core.record.Batch;

public class CompositeRecordWriterListener
implements RecordWriterListener {
    private List<RecordWriterListener> listeners;

    public CompositeRecordWriterListener() {
        this(new ArrayList<RecordWriterListener>());
    }

    public CompositeRecordWriterListener(List<RecordWriterListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeRecordWriting(Batch batch) {
        for (RecordWriterListener listener : this.listeners) {
            listener.beforeRecordWriting(batch);
        }
    }

    @Override
    public void afterRecordWriting(Batch batch) {
        for (RecordWriterListener listener : this.listeners) {
            listener.afterRecordWriting(batch);
        }
    }

    @Override
    public void onRecordWritingException(Batch batch, Throwable throwable) {
        for (RecordWriterListener listener : this.listeners) {
            listener.onRecordWritingException(batch, throwable);
        }
    }

    public void addRecordWriterListener(RecordWriterListener recordWriterListener) {
        this.listeners.add(recordWriterListener);
    }
}

