/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.listener;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.easybatch.core.listener.PipelineListener;
import org.easybatch.core.record.Record;

public class RecordProcessingTimeListener
implements PipelineListener {
    private static final Logger LOGGER = Logger.getLogger(RecordProcessingTimeListener.class.getName());
    private long recordNumber;
    private long startTime;

    @Override
    public Record beforeRecordProcessing(Record inputRecord) {
        this.recordNumber = inputRecord.getHeader().getNumber();
        this.startTime = System.currentTimeMillis();
        return inputRecord;
    }

    @Override
    public void afterRecordProcessing(Record inputRecord, Record outputRecord) {
        this.logProcessingTime();
    }

    @Override
    public void onRecordProcessingException(Record record, Throwable throwable) {
        this.logProcessingTime();
    }

    private void logProcessingTime() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        LOGGER.log(Level.INFO, "Record N\u00b0 {0} processing time = {1}ms", new Object[]{this.recordNumber, elapsedTime});
    }
}

