/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.mapper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easybatch.core.converter.AtomicIntegerTypeConverter;
import org.easybatch.core.converter.AtomicLongTypeConverter;
import org.easybatch.core.converter.BigDecimalTypeConverter;
import org.easybatch.core.converter.BigIntegerTypeConverter;
import org.easybatch.core.converter.BooleanTypeConverter;
import org.easybatch.core.converter.ByteTypeConverter;
import org.easybatch.core.converter.CharacterTypeConverter;
import org.easybatch.core.converter.DateTypeConverter;
import org.easybatch.core.converter.DoubleTypeConverter;
import org.easybatch.core.converter.FloatTypeConverter;
import org.easybatch.core.converter.GregorianCalendarTypeConverter;
import org.easybatch.core.converter.IntegerTypeConverter;
import org.easybatch.core.converter.LongTypeConverter;
import org.easybatch.core.converter.ShortTypeConverter;
import org.easybatch.core.converter.SqlDateTypeConverter;
import org.easybatch.core.converter.SqlTimeTypeConverter;
import org.easybatch.core.converter.SqlTimestampTypeConverter;
import org.easybatch.core.converter.StringTypeConverter;
import org.easybatch.core.converter.TypeConverter;
import org.easybatch.core.mapper.BeanIntrospectionException;
import org.easybatch.core.mapper.TypeConverterRegistrationException;

public class ObjectMapper<T> {
    private static final Logger LOGGER = Logger.getLogger(ObjectMapper.class.getName());
    private Class<T> objectType;
    private Map<String, Method> setters;
    private Map<Class<?>, TypeConverter<String, ?>> typeConverters;

    public ObjectMapper(Class<T> objectType) {
        this.objectType = objectType;
        this.initializeTypeConverters();
        this.initializeSetters();
    }

    public T mapObject(Map<String, String> values) throws Exception {
        T result = this.createInstance();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String field = entry.getKey();
            String value = values.get(field);
            Method setter = this.setters.get(field);
            if (setter == null) {
                LOGGER.log(Level.WARNING, "No public setter found for field {0}, this field will be set to null (if object type) or default value (if primitive type)", field);
                continue;
            }
            Class<?> type = setter.getParameterTypes()[0];
            TypeConverter<String, ?> typeConverter = this.typeConverters.get(type);
            if (typeConverter == null) {
                LOGGER.log(Level.WARNING, "Type conversion not supported for type {0}, field {1} will be set to null (if object type) or default value (if primitive type)", new Object[]{type, field});
                continue;
            }
            if (value == null) {
                LOGGER.log(Level.WARNING, "Attempting to convert null to type {0} for field {1}, this field will be set to null (if object type) or default value (if primitive type)", new Object[]{type, field});
                continue;
            }
            if (value.isEmpty()) {
                LOGGER.log(Level.FINE, "Attempting to convert an empty string to type {0} for field {1}, this field will be ignored", new Object[]{type, field});
                continue;
            }
            this.convertValue(result, field, value, setter, type, typeConverter);
        }
        return result;
    }

    private void initializeSetters() {
        this.setters = new HashMap<String, Method>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.objectType);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            this.getSetters(propertyDescriptors);
        }
        catch (IntrospectionException e) {
            throw new BeanIntrospectionException("Unable to introspect target type " + this.objectType.getName(), e);
        }
    }

    private void getSetters(PropertyDescriptor[] propertyDescriptors) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            this.setters.put(propertyDescriptor.getName(), propertyDescriptor.getWriteMethod());
        }
        this.setters.remove("class");
    }

    private T createInstance() throws Exception {
        try {
            return this.objectType.newInstance();
        }
        catch (Exception e) {
            throw new Exception(String.format("Unable to create a new instance of target type %s", this.objectType.getName()), e);
        }
    }

    private void convertValue(Object result, String field, String value, Method setter, Class<?> type, TypeConverter<String, ?> typeConverter) throws Exception {
        try {
            Object typedValue = typeConverter.convert(value);
            setter.invoke(result, typedValue);
        }
        catch (Exception e) {
            throw new Exception(String.format("Unable to convert %s to type %s for field %s", value, type, field), e);
        }
    }

    private void initializeTypeConverters() {
        this.typeConverters = new HashMap();
        this.typeConverters.put(AtomicInteger.class, new AtomicIntegerTypeConverter());
        this.typeConverters.put(AtomicLong.class, new AtomicLongTypeConverter());
        this.typeConverters.put(BigDecimal.class, new BigDecimalTypeConverter());
        this.typeConverters.put(BigInteger.class, new BigIntegerTypeConverter());
        this.typeConverters.put(Boolean.class, new BooleanTypeConverter());
        this.typeConverters.put(Boolean.TYPE, new BooleanTypeConverter());
        this.typeConverters.put(Byte.class, new ByteTypeConverter());
        this.typeConverters.put(Byte.TYPE, new ByteTypeConverter());
        this.typeConverters.put(Character.class, new CharacterTypeConverter());
        this.typeConverters.put(Character.TYPE, new CharacterTypeConverter());
        this.typeConverters.put(Double.class, new DoubleTypeConverter());
        this.typeConverters.put(Double.TYPE, new DoubleTypeConverter());
        this.typeConverters.put(Float.class, new FloatTypeConverter());
        this.typeConverters.put(Float.TYPE, new FloatTypeConverter());
        this.typeConverters.put(Integer.class, new IntegerTypeConverter());
        this.typeConverters.put(Integer.TYPE, new IntegerTypeConverter());
        this.typeConverters.put(Long.class, new LongTypeConverter());
        this.typeConverters.put(Long.TYPE, new LongTypeConverter());
        this.typeConverters.put(Short.class, new ShortTypeConverter());
        this.typeConverters.put(Short.TYPE, new ShortTypeConverter());
        this.typeConverters.put(java.util.Date.class, new DateTypeConverter());
        this.typeConverters.put(Calendar.class, new GregorianCalendarTypeConverter());
        this.typeConverters.put(GregorianCalendar.class, new GregorianCalendarTypeConverter());
        this.typeConverters.put(Date.class, new SqlDateTypeConverter());
        this.typeConverters.put(Time.class, new SqlTimeTypeConverter());
        this.typeConverters.put(Timestamp.class, new SqlTimestampTypeConverter());
        this.typeConverters.put(String.class, new StringTypeConverter());
    }

    public void registerTypeConverter(TypeConverter<String, ?> typeConverter) {
        Class<?> typeConverterClass = typeConverter.getClass();
        Type[] genericInterfaces = typeConverterClass.getGenericInterfaces();
        Type genericInterface = genericInterfaces[0];
        if (!(genericInterface instanceof ParameterizedType)) {
            LOGGER.log(Level.WARNING, "The type converter {0} should be a parametrized type", typeConverterClass.getName());
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
        Type type = parameterizedType.getActualTypeArguments()[1];
        try {
            Class<?> clazz = Class.forName(this.getClassName(type));
            this.typeConverters.put(clazz, typeConverter);
        }
        catch (ClassNotFoundException e) {
            throw new TypeConverterRegistrationException("Unable to register custom type converter " + typeConverterClass.getName(), e);
        }
    }

    private String getClassName(Type actualTypeArgument) {
        return actualTypeArgument.toString().substring(6);
    }
}

