/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.processor;

import java.util.ArrayList;
import java.util.List;
import org.easybatch.core.processor.RecordProcessor;
import org.easybatch.core.record.Record;

public class CompositeRecordProcessor
implements RecordProcessor {
    private List<RecordProcessor> processors;

    public CompositeRecordProcessor() {
        this(new ArrayList<RecordProcessor>());
    }

    public CompositeRecordProcessor(List<RecordProcessor> processors) {
        this.processors = processors;
    }

    public Record processRecord(Record record) throws Exception {
        Record<Object> processedRecord = record;
        for (RecordProcessor processor : this.processors) {
            processedRecord = processor.processRecord(processedRecord);
            if (processedRecord != null) continue;
            return null;
        }
        return processedRecord;
    }

    public void addRecordProcessor(RecordProcessor recordProcessor) {
        this.processors.add(recordProcessor);
    }
}

