/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.reader;

import java.util.concurrent.BlockingQueue;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.PoisonRecord;
import org.easybatch.core.record.Record;

public class BlockingQueueRecordReader
implements RecordReader {
    private int poisonRecords;
    private int totalPoisonRecords;
    private BlockingQueue<Record> queue;

    public BlockingQueueRecordReader(BlockingQueue<Record> queue) {
        this(queue, 1);
    }

    public BlockingQueueRecordReader(BlockingQueue<Record> queue, int totalPoisonRecords) {
        this.queue = queue;
        this.totalPoisonRecords = totalPoisonRecords;
    }

    @Override
    public void open() {
        this.poisonRecords = 0;
    }

    @Override
    public Record readRecord() throws Exception {
        if (this.poisonRecords == this.totalPoisonRecords) {
            return null;
        }
        Record record = this.queue.take();
        if (record instanceof PoisonRecord) {
            ++this.poisonRecords;
        }
        return record;
    }

    @Override
    public void close() {
    }
}

