/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.FileRecord;
import org.easybatch.core.record.Header;
import org.easybatch.core.util.Utils;

public class FileRecordReader
implements RecordReader {
    private File directory;
    private Iterator<File> iterator;
    private long currentRecordNumber;
    private boolean recursive;

    public FileRecordReader(File directory) {
        this(directory, false);
    }

    public FileRecordReader(File directory, boolean recursive) {
        Utils.checkNotNull(directory, "directory");
        this.directory = directory;
        this.recursive = recursive;
    }

    public FileRecordReader(Path path) {
        this(path, false);
    }

    public FileRecordReader(Path path, boolean recursive) {
        Utils.checkNotNull(path, "path");
        this.directory = path.toFile();
        this.recursive = recursive;
    }

    @Override
    public void open() throws Exception {
        this.checkDirectory();
        this.iterator = this.getFiles(this.directory).listIterator();
        this.currentRecordNumber = 0L;
    }

    private List<File> getFiles(File directory) throws IOException {
        int maxDepth = this.recursive ? Integer.MAX_VALUE : 1;
        FilesCollector filesCollector = new FilesCollector();
        EnumSet<FileVisitOption> fileVisitOptions = EnumSet.noneOf(FileVisitOption.class);
        Files.walkFileTree(directory.toPath(), fileVisitOptions, maxDepth, filesCollector);
        return filesCollector.getFiles();
    }

    private void checkDirectory() {
        Utils.checkArgument(this.directory.exists(), String.format("Directory %s does not exist.", this.getDataSourceName()));
        Utils.checkArgument(this.directory.isDirectory(), String.format("%s is not a directory.", this.getDataSourceName()));
        Utils.checkArgument(this.directory.canRead(), String.format("Unable to read files from directory %s. Permission denied.", this.getDataSourceName()));
    }

    @Override
    public FileRecord readRecord() {
        Header header = new Header(++this.currentRecordNumber, this.getDataSourceName(), new Date());
        if (this.iterator.hasNext()) {
            return new FileRecord(header, this.iterator.next());
        }
        return null;
    }

    private String getDataSourceName() {
        return this.directory.getAbsolutePath();
    }

    @Override
    public void close() {
    }

    private class FilesCollector
    implements FileVisitor<Path> {
        private List<File> files = new ArrayList<File>();

        FilesCollector() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                this.files.add(file.toFile());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            return FileVisitResult.CONTINUE;
        }

        public List<File> getFiles() {
            return this.files;
        }
    }
}

