/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.reader;

import java.util.Date;
import java.util.Iterator;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.GenericRecord;
import org.easybatch.core.record.Header;
import org.easybatch.core.util.Utils;

public class IterableRecordReader
implements RecordReader {
    private long currentRecordNumber;
    private Iterator iterator;

    public IterableRecordReader(Iterable dataSource) {
        Utils.checkNotNull(dataSource, "data source");
        this.iterator = dataSource.iterator();
    }

    @Override
    public void open() throws Exception {
        this.currentRecordNumber = 0L;
    }

    @Override
    public GenericRecord readRecord() throws Exception {
        Header header = new Header(++this.currentRecordNumber, this.getDataSourceName(), new Date());
        if (this.iterator.hasNext()) {
            return new GenericRecord(header, this.iterator.next());
        }
        return null;
    }

    private String getDataSourceName() {
        return "In-Memory Iterable";
    }

    @Override
    public void close() {
    }
}

