/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.reader;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.Record;
import org.easybatch.core.retry.RetryPolicy;
import org.easybatch.core.retry.RetryTemplate;

public class RetryableRecordReader
implements RecordReader {
    private RecordReader delegate;
    private RecordReadingCallable recordReadingCallable;
    private RecordReadingTemplate recordReadingTemplate;

    public RetryableRecordReader(RecordReader delegate, RetryPolicy retryPolicy) {
        this.delegate = delegate;
        this.recordReadingCallable = new RecordReadingCallable(delegate);
        this.recordReadingTemplate = new RecordReadingTemplate(retryPolicy);
    }

    @Override
    public void open() throws Exception {
        this.delegate.open();
    }

    @Override
    public Record readRecord() throws Exception {
        return this.recordReadingTemplate.execute(this.recordReadingCallable);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    private class RecordReadingTemplate
    extends RetryTemplate {
        private final Logger LOGGER;

        RecordReadingTemplate(RetryPolicy retryPolicy) {
            super(retryPolicy);
            this.LOGGER = Logger.getLogger(RecordReadingTemplate.class.getName());
        }

        @Override
        protected void beforeCall() {
        }

        @Override
        protected void afterCall(Object result) {
        }

        @Override
        protected void onException(Exception e) {
            this.LOGGER.log(Level.SEVERE, "Unable to read next record", e);
        }

        @Override
        protected void onMaxAttempts(Exception e) {
            this.LOGGER.log(Level.SEVERE, "Unable to read next record after {0} attempt(s)", this.retryPolicy.getMaxAttempts());
        }

        @Override
        protected void beforeWait() {
            this.LOGGER.log(Level.INFO, "Waiting for {0} {1} before retrying to read next record", new Object[]{this.retryPolicy.getDelay(), this.retryPolicy.getTimeUnit()});
        }

        @Override
        protected void afterWait() {
        }
    }

    private class RecordReadingCallable
    implements Callable<Record> {
        private RecordReader recordReader;

        RecordReadingCallable(RecordReader recordReader) {
            this.recordReader = recordReader;
        }

        @Override
        public Record call() throws Exception {
            return this.recordReader.readRecord();
        }
    }
}

