/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.reader;

import java.util.Date;
import java.util.Scanner;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.Header;
import org.easybatch.core.record.Record;
import org.easybatch.core.record.StringRecord;

public class StandardInputRecordReader
implements RecordReader {
    private static final String DEFAULT_TERMINATION_WORD = "quit";
    private Scanner scanner;
    private long recordNumber;
    private String terminationInput;

    public StandardInputRecordReader() {
        this(DEFAULT_TERMINATION_WORD);
    }

    public StandardInputRecordReader(String terminationInput) {
        this.terminationInput = terminationInput;
    }

    @Override
    public void open() {
        this.scanner = new Scanner(System.in);
    }

    @Override
    public Record readRecord() throws Exception {
        boolean stop;
        String payload = this.scanner.nextLine();
        boolean bl = stop = payload != null && !payload.isEmpty() && payload.equalsIgnoreCase(this.terminationInput);
        if (stop) {
            return null;
        }
        Header header = new Header(++this.recordNumber, this.getDataSourceName(), new Date());
        return new StringRecord(header, payload);
    }

    private String getDataSourceName() {
        return "Standard Input";
    }

    @Override
    public void close() {
        this.scanner.close();
    }
}

