/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.reader;

import java.util.Date;
import java.util.Scanner;
import org.easybatch.core.reader.RecordReader;
import org.easybatch.core.record.Header;
import org.easybatch.core.record.StringRecord;

public class StringRecordReader
implements RecordReader {
    private long currentRecordNumber;
    private Scanner scanner;
    private String dataSource;

    public StringRecordReader(String dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void open() {
        this.currentRecordNumber = 1L;
        this.scanner = new Scanner(this.dataSource);
    }

    @Override
    public StringRecord readRecord() {
        Header header = new Header(this.currentRecordNumber++, this.getDataSourceName(), new Date());
        String payload = this.scanner.hasNextLine() ? this.scanner.nextLine() : null;
        return payload == null ? null : new StringRecord(header, payload);
    }

    private String getDataSourceName() {
        return "In-Memory String";
    }

    @Override
    public void close() {
        this.scanner.close();
    }
}

