/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.easybatch.core.record.Record;
import org.easybatch.core.util.Utils;

public class Batch
implements Iterable<Record> {
    private List<Record> records = new ArrayList<Record>();

    public Batch() {
    }

    public Batch(Record ... records) {
        Collections.addAll(this.records, records);
    }

    public Batch(List<Record> records) {
        this.records = records;
    }

    public void addRecord(Record record) {
        this.records.add(record);
    }

    public void removeRecord(Record record) {
        this.records.remove(record);
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public long size() {
        return this.records.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Batch batch = (Batch)o;
        return this.records.equals(batch.records);
    }

    public int hashCode() {
        return this.records.hashCode();
    }

    @Override
    public Iterator<Record> iterator() {
        return this.records.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Batch: {");
        stringBuilder.append(Utils.LINE_SEPARATOR);
        for (Record record : this.records) {
            stringBuilder.append('\t');
            stringBuilder.append(record);
            stringBuilder.append(Utils.LINE_SEPARATOR);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

