/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class Utils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String JAVA_IO_TMPDIR = System.getProperty("java.io.tmpdir");
    public static final String JMX_MBEAN_NAME = "org.easybatch.core.monitor:";
    public static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String DURATION_FORMAT = "%shr %smin %ssec %sms";
    public static final String NOT_APPLICABLE = "N/A";

    private Utils() {
    }

    public static void checkNotNull(Object argument, String argumentName) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("The %s must not be null", argumentName));
        }
    }

    public static void checkArgument(boolean assertion, String message) {
        if (!assertion) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Map<String, Method> getGetters(Class type) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Method> getters = new HashMap<String, Method>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            getters.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod());
        }
        getters.remove("class");
        return getters;
    }

    public static String formatTime(long time) {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date(time));
    }

    public static String formatDuration(long duration) {
        return String.format(DURATION_FORMAT, TimeUnit.MILLISECONDS.toHours(duration) % 24L, TimeUnit.MILLISECONDS.toMinutes(duration) % 60L, TimeUnit.MILLISECONDS.toSeconds(duration) % 60L, duration % 1000L);
    }

    public static String formatErrorThreshold(long errorThreshold) {
        return errorThreshold == Long.MAX_VALUE ? NOT_APPLICABLE : String.valueOf(errorThreshold);
    }
}

