/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.writer.RecordWriter;

public class BlockingQueueRecordWriter
implements RecordWriter {
    private List<BlockingQueue<Record>> blockingQueues;

    public BlockingQueueRecordWriter(BlockingQueue<Record> blockingQueue) {
        this(Collections.singletonList(blockingQueue));
    }

    public BlockingQueueRecordWriter(List<BlockingQueue<Record>> blockingQueues) {
        this.blockingQueues = blockingQueues;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void writeRecords(Batch batch) throws Exception {
        for (Record record : batch) {
            for (BlockingQueue<Record> queue : this.blockingQueues) {
                queue.put(record);
            }
        }
    }

    @Override
    public void close() throws Exception {
    }
}

