/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.writer.DefaultPredicate;
import org.easybatch.core.writer.Predicate;
import org.easybatch.core.writer.RecordWriter;

public class ContentBasedBlockingQueueRecordWriter
implements RecordWriter {
    private Map<Predicate, BlockingQueue<Record>> queueMap;

    ContentBasedBlockingQueueRecordWriter(Map<Predicate, BlockingQueue<Record>> queueMap) {
        this.queueMap = queueMap;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void writeRecords(Batch batch) throws Exception {
        DefaultPredicate defaultPredicate = new DefaultPredicate();
        BlockingQueue<Record> defaultQueue = this.queueMap.get(defaultPredicate);
        for (Record record : batch) {
            boolean matched = false;
            for (Map.Entry<Predicate, BlockingQueue<Record>> entry : this.queueMap.entrySet()) {
                Predicate predicate = entry.getKey();
                if (predicate instanceof DefaultPredicate || !predicate.matches(record)) continue;
                this.queueMap.get(predicate).put(record);
                matched = true;
                break;
            }
            if (matched || defaultQueue == null) continue;
            defaultQueue.put(record);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

