/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.easybatch.core.record.Record;
import org.easybatch.core.writer.ContentBasedBlockingQueueRecordWriter;
import org.easybatch.core.writer.DefaultPredicate;
import org.easybatch.core.writer.Predicate;

public class ContentBasedBlockingQueueRecordWriterBuilder {
    private Predicate predicate;
    private Map<Predicate, BlockingQueue<Record>> queueMap = new HashMap<Predicate, BlockingQueue<Record>>();

    public ContentBasedBlockingQueueRecordWriterBuilder when(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public ContentBasedBlockingQueueRecordWriterBuilder writeTo(BlockingQueue<Record> queue) {
        if (this.predicate == null) {
            throw new IllegalStateException("You should specify a predicate before mapping a queue. Please ensure that you call when() -> writeTo() -> otherwise()  methods in that order");
        }
        this.queueMap.put(this.predicate, queue);
        this.predicate = null;
        return this;
    }

    public ContentBasedBlockingQueueRecordWriterBuilder otherwise(BlockingQueue<Record> queue) {
        this.queueMap.put(new DefaultPredicate(), queue);
        this.predicate = null;
        return this;
    }

    public ContentBasedBlockingQueueRecordWriter build() {
        if (this.queueMap.isEmpty()) {
            throw new IllegalStateException("You can not build a ContentBasedQueueRecordWriter with an empty <Predicate, Queue> mapping.");
        }
        return new ContentBasedBlockingQueueRecordWriter(this.queueMap);
    }
}

