/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.io.OutputStreamWriter;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.util.Utils;
import org.easybatch.core.writer.RecordWriter;

public class OutputStreamRecordWriter
implements RecordWriter {
    private String lineSeparator;
    private OutputStreamWriter outputStreamWriter;

    public OutputStreamRecordWriter(OutputStreamWriter outputStreamWriter) {
        this(outputStreamWriter, Utils.LINE_SEPARATOR);
    }

    public OutputStreamRecordWriter(OutputStreamWriter outputStreamWriter, String lineSeparator) {
        Utils.checkNotNull(outputStreamWriter, "output stream writer");
        Utils.checkNotNull(lineSeparator, "line separator");
        this.outputStreamWriter = outputStreamWriter;
        this.lineSeparator = lineSeparator;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void writeRecords(Batch batch) throws Exception {
        for (Record record : batch) {
            this.outputStreamWriter.write(record.getPayload().toString());
            this.outputStreamWriter.write(this.lineSeparator);
        }
        this.outputStreamWriter.flush();
    }

    @Override
    public void close() throws Exception {
        this.outputStreamWriter.close();
    }
}

