/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.writer.RecordWriter;

public class RandomBlockingQueueRecordWriter
implements RecordWriter {
    private int queuesNumber;
    private List<BlockingQueue<Record>> queues;
    private Random random;

    public RandomBlockingQueueRecordWriter(List<BlockingQueue<Record>> queues) {
        this.queues = queues;
        this.queuesNumber = queues.size();
        this.random = new Random();
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void writeRecords(Batch batch) throws Exception {
        for (Record record : batch) {
            BlockingQueue<Record> queue = this.queues.get(this.random.nextInt(this.queuesNumber));
            queue.put(record);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

