/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easybatch.core.record.Batch;
import org.easybatch.core.retry.RetryPolicy;
import org.easybatch.core.retry.RetryTemplate;
import org.easybatch.core.writer.RecordWriter;

public class RetryableRecordWriter
implements RecordWriter {
    private RecordWriter delegate;
    private RecordWritingTemplate recordWritingTemplate;

    public RetryableRecordWriter(RecordWriter delegate, RetryPolicy retryPolicy) {
        this.delegate = delegate;
        this.recordWritingTemplate = new RecordWritingTemplate(retryPolicy);
    }

    @Override
    public void open() throws Exception {
        this.delegate.open();
    }

    @Override
    public void writeRecords(Batch batch) throws Exception {
        this.recordWritingTemplate.execute(new RecordWritingCallable(this.delegate, batch));
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    private class RecordWritingTemplate
    extends RetryTemplate {
        private final Logger LOGGER;

        RecordWritingTemplate(RetryPolicy retryPolicy) {
            super(retryPolicy);
            this.LOGGER = Logger.getLogger(RecordWritingTemplate.class.getName());
        }

        @Override
        protected void beforeCall() {
        }

        @Override
        protected void afterCall(Object result) {
        }

        @Override
        protected void onException(Exception e) {
            this.LOGGER.log(Level.SEVERE, "Unable to write records", e);
        }

        @Override
        protected void onMaxAttempts(Exception e) {
            this.LOGGER.log(Level.SEVERE, "Unable to write records after {0} attempt(s)", this.retryPolicy.getMaxAttempts());
        }

        @Override
        protected void beforeWait() {
            this.LOGGER.log(Level.INFO, "Waiting for {0} {1} before retrying to write records", new Object[]{this.retryPolicy.getDelay(), this.retryPolicy.getTimeUnit()});
        }

        @Override
        protected void afterWait() {
        }
    }

    private class RecordWritingCallable
    implements Callable<Void> {
        private RecordWriter recordWriter;
        private Batch batch;

        RecordWritingCallable(RecordWriter recordWriter, Batch batch) {
            this.recordWriter = recordWriter;
            this.batch = batch;
        }

        @Override
        public Void call() throws Exception {
            this.recordWriter.writeRecords(this.batch);
            return null;
        }
    }
}

