/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.writer.RecordWriter;

public class RoundRobinBlockingQueueRecordWriter
implements RecordWriter {
    private int queuesNumber;
    private int nextQueue;
    private List<BlockingQueue<Record>> queues;

    public RoundRobinBlockingQueueRecordWriter(List<BlockingQueue<Record>> queues) {
        this.queues = queues;
        this.queuesNumber = queues.size();
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void writeRecords(Batch batch) throws Exception {
        for (Record record : batch) {
            BlockingQueue<Record> queue = this.queues.get(this.nextQueue++ % this.queuesNumber);
            queue.put(record);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

