/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.core.writer;

import java.io.StringWriter;
import org.easybatch.core.record.Batch;
import org.easybatch.core.record.Record;
import org.easybatch.core.util.Utils;
import org.easybatch.core.writer.RecordWriter;

public class StringRecordWriter
implements RecordWriter {
    private StringWriter stringWriter;

    public StringRecordWriter(StringWriter stringWriter) {
        Utils.checkNotNull(stringWriter, "string writer");
        this.stringWriter = stringWriter;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public void writeRecords(Batch batch) throws Exception {
        for (Record record : batch) {
            this.stringWriter.write(record.getPayload().toString());
            this.stringWriter.write(Utils.LINE_SEPARATOR);
        }
        this.stringWriter.flush();
    }

    @Override
    public void close() throws Exception {
        this.stringWriter.close();
    }
}

