/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.flatfile;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.Scanner;
import org.easybatch.core.api.RecordReader;
import org.easybatch.core.util.StringRecord;

public class FlatFileRecordReader
implements RecordReader {
    private int currentRecordNumber;
    private File input;
    private String charsetName;
    private Scanner scanner;
    private Scanner recordCounterScanner;

    public FlatFileRecordReader(File input) throws FileNotFoundException {
        this(input, Charset.defaultCharset().name());
    }

    public FlatFileRecordReader(File input, String charsetName) throws FileNotFoundException {
        this.input = input;
        this.charsetName = charsetName;
    }

    public StringRecord readNextRecord() {
        ++this.currentRecordNumber;
        return new StringRecord(this.currentRecordNumber, this.scanner.nextLine());
    }

    public Integer getTotalRecords() {
        int totalRecords = 0;
        while (this.recordCounterScanner.hasNextLine()) {
            ++totalRecords;
            this.recordCounterScanner.nextLine();
        }
        this.recordCounterScanner.close();
        return totalRecords;
    }

    public String getDataSourceName() {
        return this.input.getAbsolutePath();
    }

    public void open() throws Exception {
        this.currentRecordNumber = 0;
        this.scanner = new Scanner(this.input, this.charsetName);
        this.recordCounterScanner = new Scanner(this.input);
    }

    public boolean hasNextRecord() {
        return this.scanner.hasNextLine();
    }

    public void close() {
        this.scanner.close();
    }
}

