/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.flatfile.dsv;

import java.util.Arrays;
import java.util.List;
import org.easybatch.core.api.Record;
import org.easybatch.core.api.RecordMapper;
import org.easybatch.core.converter.TypeConverter;
import org.easybatch.core.mapper.ObjectMapper;
import org.easybatch.flatfile.FlatFileField;
import org.easybatch.flatfile.FlatFileRecord;

public class DelimitedRecordMapper<T>
implements RecordMapper<T> {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String DEFAULT_QUALIFIER = "";
    public static final boolean DEFAULT_WHITESPACE_TRIMMING = true;
    private String delimiter = ",";
    private boolean trimWhitespaces = true;
    private String qualifier = "";
    private ObjectMapper<T> objectMapper;
    private int recordExpectedLength;
    private List<Integer> fieldsPositions;

    private DelimitedRecordMapper() {
    }

    public DelimitedRecordMapper(Class<? extends T> recordClass) {
        this();
        this.objectMapper = new ObjectMapper(recordClass);
    }

    public DelimitedRecordMapper(Class<? extends T> recordClass, String[] fieldsMapping) {
        this();
        this.recordExpectedLength = fieldsMapping.length;
        this.objectMapper = new ObjectMapper(recordClass, fieldsMapping);
    }

    public DelimitedRecordMapper(Class<? extends T> recordClass, Integer[] fieldsPositions) {
        this();
        this.fieldsPositions = Arrays.asList(fieldsPositions);
        this.objectMapper = new ObjectMapper(recordClass);
    }

    public DelimitedRecordMapper(Class<? extends T> recordClass, Integer[] fieldsPositions, int recordExpectedLength) {
        this();
        this.fieldsPositions = Arrays.asList(fieldsPositions);
        this.recordExpectedLength = recordExpectedLength;
        this.objectMapper = new ObjectMapper(recordClass);
    }

    public DelimitedRecordMapper(Class<? extends T> recordClass, Integer[] fieldsPositions, String[] fieldsMapping) {
        this();
        this.fieldsPositions = Arrays.asList(fieldsPositions);
        this.objectMapper = new ObjectMapper(recordClass, fieldsMapping);
    }

    public DelimitedRecordMapper(Class<? extends T> recordClass, Integer[] fieldsPositions, String[] fieldsMapping, int recordExpectedLength) {
        this();
        this.fieldsPositions = Arrays.asList(fieldsPositions);
        this.recordExpectedLength = recordExpectedLength;
        this.objectMapper = new ObjectMapper(recordClass, fieldsMapping);
    }

    public T mapRecord(Record record) throws Exception {
        FlatFileRecord flatFileRecord = this.parseRecord(record);
        String[] fieldsContents = new String[flatFileRecord.getFlatFileFields().size()];
        for (FlatFileField flatFileField : flatFileRecord.getFlatFileFields()) {
            fieldsContents[flatFileField.getIndex()] = flatFileField.getRawContent();
        }
        return (T)this.objectMapper.mapObject(fieldsContents);
    }

    public FlatFileRecord parseRecord(Record record) throws Exception {
        String recordRawContent = (String)record.getRawContent();
        String[] tokens = recordRawContent.split(this.delimiter, -1);
        if (this.recordExpectedLength == 0) {
            this.recordExpectedLength = tokens.length;
        }
        if (this.objectMapper.getHeadersMapping() == null) {
            String[] headersMapping;
            String[] fieldsMapping = new String[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                int qualifierLength;
                String token = tokens[i];
                if (this.trimWhitespaces) {
                    token = token.trim();
                }
                if ((qualifierLength = this.qualifier.length()) > 0) {
                    token = token.substring(qualifierLength, token.length() - qualifierLength);
                }
                fieldsMapping[i] = token.toLowerCase();
            }
            if (this.fieldsPositions != null) {
                headersMapping = new String[this.fieldsPositions.size()];
                int j = 0;
                for (int i = 0; i < fieldsMapping.length; ++i) {
                    if (!this.fieldsPositions.contains(i + 1)) continue;
                    headersMapping[j++] = fieldsMapping[i];
                }
            } else {
                headersMapping = fieldsMapping;
            }
            this.objectMapper.setHeadersMapping(headersMapping);
        }
        if (tokens.length != this.recordExpectedLength) {
            throw new Exception("record length (" + tokens.length + " fields) not equal to expected length of " + this.recordExpectedLength + " fields");
        }
        if (this.qualifier.length() > 0) {
            for (String token : tokens) {
                if (token.startsWith(this.qualifier) && token.endsWith(this.qualifier)) continue;
                throw new Exception("field [" + token + "] is not enclosed as expected with '" + this.qualifier + "'");
            }
        }
        FlatFileRecord flatFileRecord = new FlatFileRecord(record.getNumber(), recordRawContent);
        int i = 0;
        int j = 0;
        for (String token : tokens) {
            int qualifierLength;
            if (this.trimWhitespaces) {
                token = token.trim();
            }
            if ((qualifierLength = this.qualifier.length()) > 0) {
                token = token.substring(qualifierLength, token.length() - qualifierLength);
            }
            if (this.fieldsPositions != null && !this.fieldsPositions.contains(++j)) continue;
            flatFileRecord.getFlatFileFields().add(new FlatFileField(i++, token));
        }
        return flatFileRecord;
    }

    public void setDelimiter(String delimiter) {
        String prefix = DEFAULT_QUALIFIER;
        if ("|".equals(delimiter)) {
            prefix = "\\";
        }
        this.delimiter = prefix + delimiter;
    }

    public void setTrimWhitespaces(boolean trimWhitespaces) {
        this.trimWhitespaces = trimWhitespaces;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public void registerTypeConverter(Class type, TypeConverter typeConverter) {
        this.objectMapper.registerTypeConverter(type, typeConverter);
    }
}

