/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.flatfile.flr;

import org.easybatch.core.api.Record;
import org.easybatch.core.api.RecordMapper;
import org.easybatch.core.converter.TypeConverter;
import org.easybatch.core.mapper.ObjectMapper;
import org.easybatch.flatfile.FlatFileField;
import org.easybatch.flatfile.FlatFileRecord;

public class FixedLengthRecordMapper<T>
implements RecordMapper<T> {
    private ObjectMapper<T> objectMapper;
    private int[] fieldsLength;
    private int[] fieldsOffsets;
    private int recordExpectedLength;

    public FixedLengthRecordMapper(Class<? extends T> recordClass, int[] fieldsLength, String[] fieldsMapping) {
        this.fieldsLength = (int[])fieldsLength.clone();
        this.objectMapper = new ObjectMapper(recordClass, fieldsMapping);
        for (int fieldLength : fieldsLength) {
            this.recordExpectedLength += fieldLength;
        }
        this.fieldsOffsets = this.calculateOffsets(fieldsLength);
    }

    public T mapRecord(Record record) throws Exception {
        FlatFileRecord flatFileRecord = this.parseRecord(record);
        String[] fieldsContents = new String[flatFileRecord.getFlatFileFields().size()];
        for (FlatFileField flatFileField : flatFileRecord.getFlatFileFields()) {
            fieldsContents[flatFileField.getIndex()] = flatFileField.getRawContent();
        }
        return (T)this.objectMapper.mapObject(fieldsContents);
    }

    public FlatFileRecord parseRecord(Record record) throws Exception {
        String recordRawContent = (String)record.getRawContent();
        int recordLength = recordRawContent.length();
        if (recordLength != this.recordExpectedLength) {
            throw new Exception("record length " + recordLength + " not equal to expected length of " + this.recordExpectedLength);
        }
        FlatFileRecord flatFileRecord = new FlatFileRecord(record.getNumber(), recordRawContent);
        for (int i = 0; i < this.fieldsLength.length; ++i) {
            String token = recordRawContent.substring(this.fieldsOffsets[i], this.fieldsOffsets[i + 1]);
            FlatFileField flatFileField = new FlatFileField(i, token);
            flatFileRecord.getFlatFileFields().add(flatFileField);
        }
        return flatFileRecord;
    }

    private int[] calculateOffsets(int[] lengths) {
        int[] offsets = new int[lengths.length + 1];
        offsets[0] = 0;
        for (int i = 0; i < lengths.length; ++i) {
            offsets[i + 1] = offsets[i] + lengths[i];
        }
        return offsets;
    }

    public void registerTypeConverter(Class type, TypeConverter typeConverter) {
        this.objectMapper.registerTypeConverter(type, typeConverter);
    }
}

