/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.json;

import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easybatch.core.processor.RecordCompactor;
import org.easybatch.json.JsonRecord;
import org.easybatch.json.JsonRecordReader;

public class JsonRecordCompactor
extends RecordCompactor {
    private static final Logger LOGGER = Logger.getLogger(JsonRecordCompactor.class.getName());

    protected String compact(String payload) {
        if (payload == null) {
            return null;
        }
        if (payload.trim().isEmpty()) {
            return "";
        }
        String dataSource = "[" + payload + "]";
        return this.doCompactPayload(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doCompactPayload(String dataSource) {
        String flatJson = "";
        JsonRecordReader jsonRecordReader = null;
        try {
            jsonRecordReader = new JsonRecordReader(new ByteArrayInputStream(dataSource.getBytes()));
            jsonRecordReader.open();
            JsonRecord jsonRecord = jsonRecordReader.readRecord();
            if (jsonRecord != null) {
                flatJson = (String)jsonRecord.getPayload();
            }
            String string = flatJson;
            return string;
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Unable to compact record paylaod", exception);
            String string = "";
            return string;
        }
        finally {
            if (jsonRecordReader != null) {
                try {
                    jsonRecordReader.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Unable to close json reader", e);
                }
            }
        }
    }
}

