/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.integration.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Date;
import org.easybatch.core.api.Header;
import org.easybatch.core.api.RecordReader;
import org.easybatch.integration.mongodb.MongoDBRecord;

public class MongoDBRecordReader
implements RecordReader {
    private DBCollection collection;
    private DBObject query;
    private DBCursor cursor;
    private boolean limit;
    private int nbLimit;
    private boolean skip;
    private int nbSkip;
    private boolean sort;
    private DBObject orderBy;
    private long currentRecordNumber;

    public MongoDBRecordReader(DBCollection collection, DBObject query) {
        this.collection = collection;
        this.query = query;
    }

    public void open() throws Exception {
        this.currentRecordNumber = 0L;
        this.cursor = this.collection.find(this.query);
        if (this.limit) {
            this.cursor.limit(this.nbLimit);
        }
        if (this.skip) {
            this.cursor.skip(this.nbSkip);
        }
        if (this.sort) {
            this.cursor.sort(this.orderBy);
        }
    }

    public boolean hasNextRecord() {
        return this.cursor.hasNext();
    }

    public MongoDBRecord readNextRecord() throws Exception {
        Header header = new Header(Long.valueOf(++this.currentRecordNumber), this.getDataSourceName(), new Date());
        return new MongoDBRecord(header, this.cursor.next());
    }

    public Long getTotalRecords() {
        return this.cursor.count();
    }

    public String getDataSourceName() {
        return "MongoDB collection: " + this.collection.getName();
    }

    public void close() throws Exception {
        this.cursor.close();
    }

    public void setLimit(int limit) {
        this.nbLimit = limit;
        this.limit = true;
    }

    public void setSkip(int skip) {
        this.nbSkip = skip;
        this.skip = true;
    }

    public void setSort(DBObject orderBy) {
        this.orderBy = orderBy;
        this.sort = true;
    }
}

