/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.integration.spring;

import java.util.List;
import org.easybatch.core.api.Engine;
import org.easybatch.core.api.RecordFilter;
import org.easybatch.core.api.RecordMapper;
import org.easybatch.core.api.RecordProcessor;
import org.easybatch.core.api.RecordReader;
import org.easybatch.core.api.RecordValidator;
import org.easybatch.core.api.event.EventManager;
import org.easybatch.core.api.event.job.JobEventListener;
import org.easybatch.core.api.event.step.RecordFilterEventListener;
import org.easybatch.core.api.event.step.RecordMapperEventListener;
import org.easybatch.core.api.event.step.RecordProcessorEventListener;
import org.easybatch.core.api.event.step.RecordReaderEventListener;
import org.easybatch.core.api.event.step.RecordValidatorEventListener;
import org.easybatch.core.api.handler.ErrorRecordHandler;
import org.easybatch.core.api.handler.FilteredRecordHandler;
import org.easybatch.core.api.handler.IgnoredRecordHandler;
import org.easybatch.core.api.handler.RejectedRecordHandler;
import org.easybatch.core.impl.EngineBuilder;
import org.springframework.beans.factory.FactoryBean;

public class EngineFactoryBean
implements FactoryBean {
    private RecordReader recordReader;
    private List<RecordFilter> filterChain;
    private RecordMapper recordMapper;
    private List<RecordValidator> validationPipeline;
    private List<RecordProcessor> processingPipeline;
    private FilteredRecordHandler filteredRecordHandler;
    private IgnoredRecordHandler ignoredRecordHandler;
    private RejectedRecordHandler rejectedRecordHandler;
    private ErrorRecordHandler errorRecordHandler;
    private List<JobEventListener> jobEventListeners;
    private List<RecordReaderEventListener> recordReaderEventListeners;
    private List<RecordFilterEventListener> recordFilterEventListeners;
    private List<RecordMapperEventListener> recordMapperEventListeners;
    private List<RecordValidatorEventListener> recordValidatorEventListeners;
    private List<RecordProcessorEventListener> recordProcessorEventListeners;
    private EventManager eventManager;

    public Engine getObject() throws Exception {
        EngineBuilder engineBuilder = new EngineBuilder();
        this.registerMainComponents(engineBuilder);
        this.registerCustomHandlers(engineBuilder);
        this.registerCustomEventListeners(engineBuilder);
        return engineBuilder.build();
    }

    private void registerMainComponents(EngineBuilder engineBuilder) {
        if (this.recordReader != null) {
            engineBuilder.reader(this.recordReader);
        }
        if (this.filterChain != null) {
            for (RecordFilter recordFilter : this.filterChain) {
                engineBuilder.filter(recordFilter);
            }
        }
        if (this.recordMapper != null) {
            engineBuilder.mapper(this.recordMapper);
        }
        if (this.validationPipeline != null) {
            for (RecordValidator recordValidator : this.validationPipeline) {
                engineBuilder.validator(recordValidator);
            }
        }
        if (this.processingPipeline != null) {
            for (RecordProcessor recordProcessor : this.processingPipeline) {
                engineBuilder.processor(recordProcessor);
            }
        }
    }

    private void registerCustomEventListeners(EngineBuilder engineBuilder) {
        if (this.jobEventListeners != null) {
            for (JobEventListener jobEventListener : this.jobEventListeners) {
                engineBuilder.jobEventListener(jobEventListener);
            }
        }
        if (this.recordReaderEventListeners != null) {
            for (RecordReaderEventListener recordReaderEventListener : this.recordReaderEventListeners) {
                engineBuilder.recordReaderEventListener(recordReaderEventListener);
            }
        }
        if (this.recordFilterEventListeners != null) {
            for (RecordFilterEventListener recordFilterEventListener : this.recordFilterEventListeners) {
                engineBuilder.recordFilterEventListener(recordFilterEventListener);
            }
        }
        if (this.recordMapperEventListeners != null) {
            for (RecordMapperEventListener recordMapperEventListener : this.recordMapperEventListeners) {
                engineBuilder.recordMapperEventListener(recordMapperEventListener);
            }
        }
        if (this.recordValidatorEventListeners != null) {
            for (RecordValidatorEventListener recordValidatorEventListener : this.recordValidatorEventListeners) {
                engineBuilder.recordValidatorEventListener(recordValidatorEventListener);
            }
        }
        if (this.recordProcessorEventListeners != null) {
            for (RecordProcessorEventListener recordProcessorEventListener : this.recordProcessorEventListeners) {
                engineBuilder.recordProcessorEventListener(recordProcessorEventListener);
            }
        }
        if (this.eventManager != null) {
            engineBuilder.eventManager(this.eventManager);
        }
    }

    private void registerCustomHandlers(EngineBuilder engineBuilder) {
        if (this.filteredRecordHandler != null) {
            engineBuilder.filteredRecordHandler(this.filteredRecordHandler);
        }
        if (this.ignoredRecordHandler != null) {
            engineBuilder.ignoredRecordHandler(this.ignoredRecordHandler);
        }
        if (this.rejectedRecordHandler != null) {
            engineBuilder.rejectedRecordHandler(this.rejectedRecordHandler);
        }
        if (this.errorRecordHandler != null) {
            engineBuilder.errorRecordHandler(this.errorRecordHandler);
        }
    }

    public Class<Engine> getObjectType() {
        return Engine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setRecordReader(RecordReader recordReader) {
        this.recordReader = recordReader;
    }

    public void setFilterChain(List<RecordFilter> filterChain) {
        this.filterChain = filterChain;
    }

    public void setRecordMapper(RecordMapper recordMapper) {
        this.recordMapper = recordMapper;
    }

    public void setValidationPipeline(List<RecordValidator> validationPipeline) {
        this.validationPipeline = validationPipeline;
    }

    public void setProcessingPipeline(List<RecordProcessor> processingPipeline) {
        this.processingPipeline = processingPipeline;
    }

    public void setFilteredRecordHandler(FilteredRecordHandler filteredRecordHandler) {
        this.filteredRecordHandler = filteredRecordHandler;
    }

    public void setIgnoredRecordHandler(IgnoredRecordHandler ignoredRecordHandler) {
        this.ignoredRecordHandler = ignoredRecordHandler;
    }

    public void setRejectedRecordHandler(RejectedRecordHandler rejectedRecordHandler) {
        this.rejectedRecordHandler = rejectedRecordHandler;
    }

    public void setErrorRecordHandler(ErrorRecordHandler errorRecordHandler) {
        this.errorRecordHandler = errorRecordHandler;
    }

    public void setJobEventListeners(List<JobEventListener> jobEventListeners) {
        this.jobEventListeners = jobEventListeners;
    }

    public void setRecordReaderEventListeners(List<RecordReaderEventListener> recordReaderEventListeners) {
        this.recordReaderEventListeners = recordReaderEventListeners;
    }

    public void setRecordFilterEventListeners(List<RecordFilterEventListener> recordFilterEventListeners) {
        this.recordFilterEventListeners = recordFilterEventListeners;
    }

    public void setRecordMapperEventListeners(List<RecordMapperEventListener> recordMapperEventListeners) {
        this.recordMapperEventListeners = recordMapperEventListeners;
    }

    public void setRecordValidatorEventListeners(List<RecordValidatorEventListener> recordValidatorEventListeners) {
        this.recordValidatorEventListeners = recordValidatorEventListeners;
    }

    public void setRecordProcessorEventListeners(List<RecordProcessorEventListener> recordProcessorEventListeners) {
        this.recordProcessorEventListeners = recordProcessorEventListeners;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

