/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.integration.spring;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.easybatch.core.api.Record;
import org.easybatch.core.api.RecordMapper;
import org.easybatch.core.api.RecordMappingException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;

public class SpringJdbcRecordMapper<T>
implements RecordMapper<T> {
    private final Class<T> type;

    public SpringJdbcRecordMapper(Class<T> type) {
        this.type = type;
    }

    public T mapRecord(Record record) throws RecordMappingException {
        ResultSet resultSet = (ResultSet)record.getPayload();
        BeanPropertyRowMapper beanPropertyRowMapper = new BeanPropertyRowMapper(this.type);
        try {
            return (T)beanPropertyRowMapper.mapRow(resultSet, record.getHeader().getNumber().intValue());
        }
        catch (SQLException e) {
            throw new RecordMappingException("Unable to map record " + record + " to target type", (Throwable)e);
        }
    }
}

