/*
 * Decompiled with CFR 0.152.
 */
package org.easybatch.test.common;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

public abstract class AbstractDatabaseTest {
    protected EmbeddedDatabaseBuilder embeddedDatabaseBuilder = new EmbeddedDatabaseBuilder().setType(EmbeddedDatabaseType.HSQL).addScript("schema.sql");
    protected EmbeddedDatabase embeddedDatabase;
    protected JdbcTemplate jdbcTemplate;

    protected void setUp() throws Exception {
        this.embeddedDatabase = this.embeddedDatabaseBuilder.build();
        this.jdbcTemplate = new JdbcTemplate((DataSource)this.embeddedDatabase);
    }

    protected void tearDown() throws Exception {
        this.embeddedDatabase.shutdown();
    }

    protected void addScript(String script) {
        this.embeddedDatabaseBuilder.addScript(script);
    }

    protected int countRowsIn(String table) throws SQLException {
        return (Integer)this.jdbcTemplate.queryForObject("select count(*) from " + table, Integer.class);
    }
}

