/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender;

import java.util.Iterator;
import net.logstash.logback.appender.AsyncDisruptorAppender;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import org.apache.juli.logging.ch.qos.logback.core.Appender;
import org.apache.juli.logging.ch.qos.logback.core.spi.AppenderAttachable;
import org.apache.juli.logging.ch.qos.logback.core.spi.AppenderAttachableImpl;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;

public abstract class DelegatingAsyncDisruptorAppender<Event extends DeferredProcessingAware>
extends AsyncDisruptorAppender<Event>
implements AppenderAttachable<Event> {
    private final AppenderAttachableImpl<Event> appenders = new AppenderAttachableImpl();

    public DelegatingAsyncDisruptorAppender() {
        this.setEventHandler(new DelegatingEventHandler());
    }

    @Override
    public void start() {
        this.startDelegateAppenders();
        super.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.stopDelegateAppenders();
    }

    private void startDelegateAppenders() {
        Iterator<Appender<Event>> appenderIter = this.appenders.iteratorForAppenders();
        while (appenderIter.hasNext()) {
            Appender<Event> appender = appenderIter.next();
            if (appender.getContext() == null) {
                appender.setContext(this.getContext());
            }
            if (appender.isStarted()) continue;
            appender.start();
        }
    }

    private void stopDelegateAppenders() {
        Iterator<Appender<Event>> appenderIter = this.appenders.iteratorForAppenders();
        while (appenderIter.hasNext()) {
            Appender<Event> appender = appenderIter.next();
            if (!appender.isStarted()) continue;
            appender.stop();
        }
    }

    @Override
    public void addAppender(Appender<Event> newAppender) {
        this.appenders.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<Event>> iteratorForAppenders() {
        return this.appenders.iteratorForAppenders();
    }

    @Override
    public Appender<Event> getAppender(String name) {
        return this.appenders.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<Event> appender) {
        return this.appenders.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.appenders.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<Event> appender) {
        return this.appenders.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.appenders.detachAppender(name);
    }

    private class DelegatingEventHandler
    implements EventHandler<AsyncDisruptorAppender.LogEvent<Event>> {
        private DelegatingEventHandler() {
        }

        @Override
        public void onEvent(AsyncDisruptorAppender.LogEvent<Event> logEvent, long sequence, boolean endOfBatch) throws Exception {
            DelegatingAsyncDisruptorAppender.this.appenders.appendLoopOnAppenders(logEvent.event);
        }
    }
}

