/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.argument;

import java.util.Arrays;
import java.util.Map;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.marker.MapEntriesAppendingMarker;
import net.logstash.logback.marker.ObjectAppendingMarker;
import net.logstash.logback.marker.ObjectFieldsAppendingMarker;
import net.logstash.logback.marker.RawJsonAppendingMarker;
import org.apache.juli.logging.ch.qos.logback.core.Context;
import org.apache.juli.logging.ch.qos.logback.core.status.StatusManager;
import org.apache.juli.logging.ch.qos.logback.core.status.WarnStatus;
import org.apache.juli.logging.org.slf4j.ILoggerFactory;
import org.apache.juli.logging.org.slf4j.LoggerFactory;

public class StructuredArguments {
    public static final String DEFAULT_KEY_VALUE_MESSAGE_FORMAT_PATTERN = "{0}={1}";
    public static final String VALUE_ONLY_MESSAGE_FORMAT_PATTERN = "{1}";

    private StructuredArguments() {
    }

    public static StructuredArgument keyValue(String key, Object value) {
        return StructuredArguments.keyValue(key, value, DEFAULT_KEY_VALUE_MESSAGE_FORMAT_PATTERN);
    }

    public static StructuredArgument kv(String key, Object value) {
        return StructuredArguments.keyValue(key, value);
    }

    public static StructuredArgument keyValue(String key, Object value, String messageFormatPattern) {
        return new ObjectAppendingMarker(key, value, messageFormatPattern);
    }

    public static StructuredArgument kv(String key, Object value, String messageFormatPattern) {
        return StructuredArguments.keyValue(key, value, messageFormatPattern);
    }

    public static StructuredArgument value(String key, Object value) {
        return StructuredArguments.keyValue(key, value, VALUE_ONLY_MESSAGE_FORMAT_PATTERN);
    }

    public static StructuredArgument v(String key, Object value) {
        return StructuredArguments.value(key, value);
    }

    public static StructuredArgument entries(Map<?, ?> map) {
        return new MapEntriesAppendingMarker(map);
    }

    public static StructuredArgument e(Map<?, ?> map) {
        return StructuredArguments.entries(map);
    }

    public static StructuredArgument fields(Object object) {
        return new ObjectFieldsAppendingMarker(object);
    }

    public static StructuredArgument f(Object object) {
        return StructuredArguments.fields(object);
    }

    public static StructuredArgument array(String fieldName, Object ... objects) {
        return new ObjectAppendingMarker(fieldName, objects);
    }

    public static StructuredArgument a(String fieldName, Object ... objects) {
        return StructuredArguments.array(fieldName, objects);
    }

    public static StructuredArgument raw(String fieldName, String rawJsonValue) {
        return new RawJsonAppendingMarker(fieldName, rawJsonValue);
    }

    public static StructuredArgument r(String fieldName, String rawJsonValue) {
        return StructuredArguments.raw(fieldName, rawJsonValue);
    }

    public static String toString(Object arg) {
        if (arg == null) {
            return "null";
        }
        Class<?> argClass = arg.getClass();
        try {
            if (!argClass.isArray()) {
                return String.valueOf(arg);
            }
            if (argClass == byte[].class) {
                return Arrays.toString((byte[])arg);
            }
            if (argClass == short[].class) {
                return Arrays.toString((short[])arg);
            }
            if (argClass == int[].class) {
                return Arrays.toString((int[])arg);
            }
            if (argClass == long[].class) {
                return Arrays.toString((long[])arg);
            }
            if (argClass == char[].class) {
                return Arrays.toString((char[])arg);
            }
            if (argClass == float[].class) {
                return Arrays.toString((float[])arg);
            }
            if (argClass == double[].class) {
                return Arrays.toString((double[])arg);
            }
            if (argClass == boolean[].class) {
                return Arrays.toString((boolean[])arg);
            }
            return Arrays.deepToString((Object[])arg);
        }
        catch (Exception e) {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            if (loggerFactory instanceof Context) {
                Context context = (Context)((Object)loggerFactory);
                StatusManager statusManager = context.getStatusManager();
                statusManager.add(new WarnStatus("Failed toString() invocation on an object of type [" + argClass.getName() + "]", StructuredArguments.class, e));
            } else {
                System.err.println("Failed toString() invocation on an object of type [" + argClass.getName() + "]");
                e.printStackTrace();
            }
            return "[FAILED toString()]";
        }
    }
}

