/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.TimeZone;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.encoder.org.apache.commons.lang.time.FastDateFormat;
import net.logstash.logback.fieldnames.LogstashCommonFieldNames;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;

public abstract class FormattedTimestampJsonProvider<Event extends DeferredProcessingAware, FieldNames extends LogstashCommonFieldNames>
extends AbstractFieldJsonProvider<Event>
implements FieldNamesAware<FieldNames> {
    public static final String FIELD_TIMESTAMP = "@timestamp";
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final TimeZone DEFAULT_TIMEZONE = null;
    private String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private TimeZone timeZone = DEFAULT_TIMEZONE;
    private FastDateFormat formatter;

    public FormattedTimestampJsonProvider() {
        this.setFieldName(FIELD_TIMESTAMP);
    }

    @Override
    public void setFieldNames(FieldNames fieldNames) {
        this.setFieldName(((LogstashCommonFieldNames)fieldNames).getTimestamp());
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        JsonWritingUtils.writeStringField(generator, this.getFieldName(), this.getFormattedTimestamp(event));
    }

    protected String getFormattedTimestamp(Event event) {
        return this.formatter.format(this.getTimestampAsMillis(event));
    }

    protected abstract long getTimestampAsMillis(Event var1);

    @Override
    public void start() {
        this.formatter = FastDateFormat.getInstance(this.pattern, this.timeZone);
        super.start();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public void setTimeZone(String timeZoneId) {
        this.timeZone = TimeZone.getTimeZone(timeZoneId);
    }
}

