/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashCommonFieldNames;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;

public class LogstashVersionJsonProvider<Event extends DeferredProcessingAware>
extends AbstractFieldJsonProvider<Event>
implements FieldNamesAware<LogstashCommonFieldNames> {
    public static final String FIELD_VERSION = "@version";
    public static final int DEFAULT_VERSION = 1;
    private int version;
    private String versionAsString;
    private boolean writeAsString;

    public LogstashVersionJsonProvider() {
        this.setFieldName(FIELD_VERSION);
        this.setVersion(1);
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        if (this.writeAsString) {
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), this.versionAsString);
        } else {
            JsonWritingUtils.writeNumberField(generator, this.getFieldName(), this.version);
        }
    }

    @Override
    public void setFieldNames(LogstashCommonFieldNames fieldNames) {
        this.setFieldName(fieldNames.getVersion());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
        this.versionAsString = Integer.toString(version);
    }

    public boolean isWriteAsString() {
        return this.writeAsString;
    }

    public void setWriteAsString(boolean writeAsString) {
        this.writeAsString = writeAsString;
    }
}

