/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.layout;

import java.io.IOException;
import net.logstash.logback.composite.CompositeJsonFormatter;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import org.apache.juli.logging.ch.qos.logback.core.Layout;
import org.apache.juli.logging.ch.qos.logback.core.LayoutBase;
import org.apache.juli.logging.ch.qos.logback.core.pattern.PatternLayoutBase;
import org.apache.juli.logging.ch.qos.logback.core.spi.DeferredProcessingAware;

public abstract class CompositeJsonLayout<Event extends DeferredProcessingAware>
extends LayoutBase<Event> {
    private boolean immediateFlush = true;
    private Layout<Event> prefix;
    private Layout<Event> suffix;
    private final CompositeJsonFormatter<Event> formatter = this.createFormatter();

    protected abstract CompositeJsonFormatter<Event> createFormatter();

    @Override
    public String doLayout(Event event) {
        String result;
        try {
            result = this.formatter.writeEventAsString(event);
        }
        catch (IOException e) {
            this.addWarn("Error formatting logging event", e);
            return null;
        }
        if (this.prefix == null && this.suffix == null) {
            return result;
        }
        String prefixResult = this.doLayoutWrapped(this.prefix, event);
        String suffixResult = this.doLayoutWrapped(this.suffix, event);
        int size = result.length() + (prefixResult == null ? 0 : prefixResult.length()) + (suffixResult == null ? 0 : suffixResult.length());
        StringBuilder stringBuilder = new StringBuilder(size);
        if (prefixResult != null) {
            stringBuilder.append(prefixResult);
        }
        stringBuilder.append(result);
        if (suffixResult != null) {
            stringBuilder.append(suffixResult);
        }
        return stringBuilder.toString();
    }

    private String doLayoutWrapped(Layout<Event> wrapped, Event event) {
        return wrapped == null ? null : wrapped.doLayout(event);
    }

    @Override
    public void start() {
        super.start();
        this.formatter.setContext(this.getContext());
        this.formatter.start();
        this.startWrapped(this.prefix);
        this.startWrapped(this.suffix);
    }

    private void startWrapped(Layout<Event> wrapped) {
        if (wrapped instanceof PatternLayoutBase) {
            PatternLayoutBase layout = (PatternLayoutBase)wrapped;
            layout.setPostCompileProcessor(null);
            layout.start();
        }
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.formatter.stop();
        this.stopWrapped(this.prefix);
        this.stopWrapped(this.suffix);
    }

    private void stopWrapped(Layout<Event> wrapped) {
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.stop();
        }
    }

    public JsonProviders<Event> getProviders() {
        return this.formatter.getProviders();
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.formatter.setProviders(jsonProviders);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.formatter.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.formatter.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.formatter.getJsonGeneratorDecorator();
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.formatter.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    protected CompositeJsonFormatter<Event> getFormatter() {
        return this.formatter;
    }

    public Layout<Event> getPrefix() {
        return this.prefix;
    }

    public void setPrefix(Layout<Event> prefix) {
        this.prefix = prefix;
    }

    public Layout<Event> getSuffix() {
        return this.suffix;
    }

    public void setSuffix(Layout<Event> suffix) {
        this.suffix = suffix;
    }
}

